/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.commons.config;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.bootstrap.config.PropertySourceLocator;
import org.springframework.cloud.kubernetes.commons.config.NormalizedSource;
import org.springframework.cloud.kubernetes.commons.config.ReadType;
import org.springframework.cloud.kubernetes.commons.config.SourceConfigProperties;
import org.springframework.cloud.kubernetes.commons.config.SourceType;
import org.springframework.core.env.CompositePropertySource;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.core.log.LogAccessor;

abstract class CommonPropertySourceLocator
implements PropertySourceLocator {
    private static final LogAccessor LOG = new LogAccessor(LogFactory.getLog(CommonPropertySourceLocator.class));
    protected final SourceConfigProperties properties;
    private final SourceType sourceType;

    CommonPropertySourceLocator(SourceConfigProperties properties, SourceType sourceType) {
        this.properties = properties;
        this.sourceType = sourceType;
    }

    protected abstract MapPropertySource getPropertySource(ConfigurableEnvironment var1, NormalizedSource var2, ReadType var3);

    public PropertySource<?> locate(Environment environment) {
        if (environment instanceof ConfigurableEnvironment) {
            ConfigurableEnvironment env = (ConfigurableEnvironment)environment;
            List<NormalizedSource> sources = this.properties.determineSources(this.sourceType, environment);
            LinkedHashSet<NormalizedSource> uniqueSources = new LinkedHashSet<NormalizedSource>(sources);
            LOG.debug((CharSequence)(this.sourceType.name() + " normalized sources : " + String.valueOf(uniqueSources)));
            CompositePropertySource composite = new CompositePropertySource("composite-" + this.sourceType.name().toLowerCase(Locale.ROOT));
            uniqueSources.forEach(secretSource -> {
                MapPropertySource propertySource = this.getPropertySource(env, (NormalizedSource)secretSource, this.properties.readType());
                if ("true".equals(propertySource.getProperty("spring.cloud.k8s.error.reading.property.source"))) {
                    LOG.warn(() -> "Failed to load source: " + String.valueOf(secretSource));
                } else {
                    LOG.debug((CharSequence)("Adding " + this.sourceType.name().toLowerCase(Locale.ROOT) + " property source " + propertySource.getName()));
                    composite.addFirstPropertySource((PropertySource)propertySource);
                }
            });
            return composite;
        }
        return null;
    }

    public Collection<PropertySource<?>> locateCollection(Environment environment) {
        return super.locateCollection(environment);
    }
}

