/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.commons.configdata;

import org.springframework.boot.bootstrap.ConfigurableBootstrapContext;
import org.springframework.boot.context.config.ConfigDataLocationResolverContext;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.cloud.kubernetes.commons.KubernetesClientProperties;
import org.springframework.cloud.kubernetes.commons.config.ConfigMapConfigProperties;
import org.springframework.cloud.kubernetes.commons.config.ConfigUtils;
import org.springframework.cloud.kubernetes.commons.config.SecretsConfigProperties;

public record ConfigDataPropertiesHolder(KubernetesClientProperties clientProperties, ConfigMapConfigProperties configMapProperties, SecretsConfigProperties secretsProperties) {
    private static final Class<ConfigMapConfigProperties> CONFIGMAP_PROPERTIES_CLASS = ConfigMapConfigProperties.class;
    private static final Class<SecretsConfigProperties> SECRETS_PROPERTIES_CLASS = SecretsConfigProperties.class;
    private static final Class<KubernetesClientProperties> CLIENT_PROPERTIES_CLASS = KubernetesClientProperties.class;

    static ConfigDataPropertiesHolder of(ConfigDataLocationResolverContext context) {
        boolean secretsEnabled;
        ConfigMapConfigProperties configMapProperties = null;
        SecretsConfigProperties secretsProperties = null;
        Binder binder = context.getBinder();
        boolean configEnabled = (Boolean)binder.bind("spring.cloud.kubernetes.config.enabled", Boolean.TYPE).orElse((Object)true);
        if (configEnabled) {
            configMapProperties = (ConfigMapConfigProperties)binder.bindOrCreate("spring.cloud.kubernetes.config", CONFIGMAP_PROPERTIES_CLASS);
        }
        if (secretsEnabled = ((Boolean)binder.bind("spring.cloud.kubernetes.secrets.enabled", Boolean.TYPE).orElse((Object)true)).booleanValue()) {
            secretsProperties = (SecretsConfigProperties)binder.bindOrCreate("spring.cloud.kubernetes.secrets", SECRETS_PROPERTIES_CLASS);
        }
        String namespace = (String)binder.bind("spring.cloud.kubernetes.client.namespace", String.class).orElse((Object)((String)binder.bind("kubernetes.namespace", String.class).orElse((Object)"")));
        KubernetesClientProperties clientProperties = ConfigDataPropertiesHolder.clientProperties(context, namespace);
        ConfigDataPropertiesHolder.registerProperties(context, clientProperties, configMapProperties, secretsProperties);
        return new ConfigDataPropertiesHolder(clientProperties, configMapProperties, secretsProperties);
    }

    private static void registerProperties(ConfigDataLocationResolverContext resolverContext, KubernetesClientProperties clientProperties, ConfigMapConfigProperties configMapProperties, SecretsConfigProperties secretsProperties) {
        ConfigurableBootstrapContext bootstrapContext = resolverContext.getBootstrapContext();
        ConfigUtils.registerSingle(bootstrapContext, CLIENT_PROPERTIES_CLASS, clientProperties, "configDataKubernetesClientProperties");
        if (configMapProperties != null) {
            ConfigUtils.registerSingle(bootstrapContext, CONFIGMAP_PROPERTIES_CLASS, configMapProperties, "configDataConfigMapConfigProperties");
        }
        if (secretsProperties != null) {
            ConfigUtils.registerSingle(bootstrapContext, SECRETS_PROPERTIES_CLASS, secretsProperties, "configDataSecretsConfigProperties");
        }
    }

    private static KubernetesClientProperties clientProperties(ConfigDataLocationResolverContext context, String namespace) {
        ConfigurableBootstrapContext bootstrapContext = context.getBootstrapContext();
        KubernetesClientProperties kubernetesClientProperties = bootstrapContext.isRegistered(CLIENT_PROPERTIES_CLASS) && bootstrapContext.get(CLIENT_PROPERTIES_CLASS) != null ? ((KubernetesClientProperties)bootstrapContext.get(CLIENT_PROPERTIES_CLASS)).withNamespace(namespace) : ((KubernetesClientProperties)context.getBinder().bindOrCreate("spring.cloud.kubernetes.client", Bindable.of(CLIENT_PROPERTIES_CLASS))).withNamespace(namespace);
        return kubernetesClientProperties;
    }
}

