/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.commons.config;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.kubernetes.commons.config.ConfigUtils;
import org.springframework.cloud.kubernetes.commons.config.MultipleSourcesContainer;
import org.springframework.cloud.kubernetes.commons.config.SourceData;
import org.springframework.cloud.kubernetes.commons.config.SourceDataFlattener;

public abstract class LabeledSourceData {
    private static final Log LOG = LogFactory.getLog(LabeledSourceData.class);

    public final SourceData compute(Map<String, String> labels, ConfigUtils.Prefix prefix, String target, boolean failFast, String namespace) {
        MultipleSourcesContainer data = MultipleSourcesContainer.empty();
        try {
            data = this.dataSupplier(labels);
            LinkedHashMap<String, Map<String, Object>> sourceData = data.data();
            String sourceDataName = ConfigUtils.sourceDataName(target, sourceData.keySet(), namespace);
            if (sourceData.isEmpty()) {
                return this.emptySourceData(labels, target, namespace);
            }
            if (prefix.getName().equals(ConfigUtils.Prefix.DEFAULT.getName())) {
                return new SourceData(sourceDataName, SourceDataFlattener.defaultFlattenedSourceData(sourceData));
            }
            if (prefix.getName().equals(ConfigUtils.Prefix.KNOWN.getName())) {
                return new SourceData(sourceDataName, SourceDataFlattener.prefixFlattenedSourceData(sourceData, prefix.prefixProvider().get()));
            }
            if (prefix.getName().equals(ConfigUtils.Prefix.DELAYED.getName())) {
                return new SourceData(sourceDataName, SourceDataFlattener.nameFlattenedSourceData(sourceData));
            }
            throw new IllegalArgumentException("Unsupported prefix: " + String.valueOf(prefix));
        }
        catch (Exception e) {
            LOG.warn((Object)"Failure in reading labeled sources");
            ConfigUtils.onException(failFast, e);
            return new SourceData(ConfigUtils.sourceDataName(target, data.data().keySet(), namespace), Map.of("spring.cloud.k8s.error.reading.property.source", "true"));
        }
    }

    private SourceData emptySourceData(Map<String, String> labels, String target, String namespace) {
        String sourceName = labels.keySet().stream().sorted().collect(Collectors.collectingAndThen(Collectors.joining("."), sortedLabels -> ConfigUtils.sourceName(target, sortedLabels, namespace)));
        return SourceData.emptyRecord(sourceName);
    }

    protected abstract MultipleSourcesContainer dataSupplier(Map<String, String> var1);
}

