/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.commons;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.springframework.boot.context.properties.bind.BindHandler;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.logging.DeferredLog;
import org.springframework.core.env.Environment;
import org.springframework.util.ObjectUtils;

public class KubernetesNamespaceProvider {
    public static final String NAMESPACE_PROPERTY = "spring.cloud.kubernetes.client.namespace";
    public static final String NAMESPACE_PATH_PROPERTY = "spring.cloud.kubernetes.client.serviceAccountNamespacePath";
    private static final DeferredLog LOG = new DeferredLog();
    private String namespacePropertyValue;
    private BindHandler bindHandler;
    private String serviceAccountNamespace;
    private Environment environment;
    private Binder binder;

    public KubernetesNamespaceProvider(Environment env) {
        this.environment = env;
        LOG.replayTo(KubernetesNamespaceProvider.class);
    }

    public KubernetesNamespaceProvider(Binder binder, BindHandler bindHandler) {
        this.binder = binder;
        this.bindHandler = bindHandler;
    }

    public KubernetesNamespaceProvider(String namespacePropertyValue) {
        this.namespacePropertyValue = namespacePropertyValue;
    }

    public static String getNamespaceFromServiceAccountFile(String path) {
        String namespace = null;
        LOG.debug((Object)("Looking for service account namespace at: [" + path + "]."));
        Path serviceAccountNamespacePath = Paths.get(path, new String[0]);
        boolean serviceAccountNamespaceExists = Files.isRegularFile(serviceAccountNamespacePath, new LinkOption[0]);
        if (serviceAccountNamespaceExists) {
            LOG.debug((Object)("Found service account namespace at: [" + String.valueOf(serviceAccountNamespacePath) + "]."));
            try {
                namespace = new String(Files.readAllBytes(serviceAccountNamespacePath));
                LOG.debug((Object)("Service account namespace value: " + String.valueOf(serviceAccountNamespacePath)));
            }
            catch (IOException ioe) {
                LOG.error((Object)("Error reading service account namespace from: [" + String.valueOf(serviceAccountNamespacePath) + "]."), (Throwable)ioe);
            }
        }
        return namespace;
    }

    public String getNamespace() {
        if (!ObjectUtils.isEmpty((Object)this.namespacePropertyValue)) {
            return this.namespacePropertyValue;
        }
        String namespace = null;
        if (this.environment != null) {
            namespace = this.environment.getProperty(NAMESPACE_PROPERTY);
        }
        if (ObjectUtils.isEmpty(namespace) && this.binder != null) {
            namespace = (String)this.binder.bind(NAMESPACE_PROPERTY, String.class).orElse(null);
        }
        return namespace != null ? namespace : this.getServiceAccountNamespace();
    }

    private String getServiceAccountNamespace() {
        String serviceAccountNamespacePathString = null;
        if (this.environment != null) {
            serviceAccountNamespacePathString = this.environment.getProperty(NAMESPACE_PATH_PROPERTY, "/var/run/secrets/kubernetes.io/serviceaccount/namespace");
        }
        if (ObjectUtils.isEmpty(serviceAccountNamespacePathString) && this.binder != null) {
            serviceAccountNamespacePathString = (String)this.binder.bind("spring.cloud.kubernetes.client.service-account-namespace-path", Bindable.of(String.class), this.bindHandler).orElse((Object)"/var/run/secrets/kubernetes.io/serviceaccount/namespace");
        }
        if (this.serviceAccountNamespace == null) {
            this.serviceAccountNamespace = KubernetesNamespaceProvider.getNamespaceFromServiceAccountFile(serviceAccountNamespacePathString);
        }
        return this.serviceAccountNamespace;
    }
}

