/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.commons;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.actuate.info.Info;
import org.springframework.boot.actuate.info.InfoContributor;

public abstract class AbstractKubernetesInfoContributor
implements InfoContributor {
    public static final String KUBERNETES = "kubernetes";
    public static final String INSIDE = "inside";
    public static final String NAMESPACE = "namespace";
    public static final String POD_NAME = "podName";
    public static final String POD_IP = "podIp";
    public static final String SERVICE_ACCOUNT = "serviceAccount";
    public static final String NODE_NAME = "nodeName";
    public static final String HOST_IP = "hostIp";
    private static final Log LOG = LogFactory.getLog(AbstractKubernetesInfoContributor.class);

    public void contribute(Info.Builder builder) {
        try {
            builder.withDetail(KUBERNETES, this.getDetails());
        }
        catch (Exception e) {
            LOG.warn((Object)"Failed to get pod details", (Throwable)e);
        }
    }

    public abstract Map<String, Object> getDetails();
}

