/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.commons.config;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.springframework.cloud.kubernetes.commons.config.ConfigUtils;
import org.springframework.cloud.kubernetes.commons.config.NormalizedSource;
import org.springframework.cloud.kubernetes.commons.config.NormalizedSourceType;

public final class LabeledConfigMapNormalizedSource
extends NormalizedSource {
    private final Map<String, String> labels;
    private final ConfigUtils.Prefix prefix;
    private final boolean includeProfileSpecificSources;

    public LabeledConfigMapNormalizedSource(String namespace, Map<String, String> labels, boolean failFast, ConfigUtils.Prefix prefix, boolean includeProfileSpecificSources) {
        super(null, namespace, failFast);
        this.labels = Collections.unmodifiableMap(Objects.requireNonNull(labels));
        this.prefix = Objects.requireNonNull(prefix);
        this.includeProfileSpecificSources = includeProfileSpecificSources;
    }

    public LabeledConfigMapNormalizedSource(String namespace, Map<String, String> labels, boolean failFast, boolean includeProfileSpecificSources) {
        super(null, namespace, failFast);
        this.labels = Collections.unmodifiableMap(Objects.requireNonNull(labels));
        this.prefix = ConfigUtils.Prefix.DEFAULT;
        this.includeProfileSpecificSources = includeProfileSpecificSources;
    }

    public Map<String, String> labels() {
        return this.labels;
    }

    public ConfigUtils.Prefix prefix() {
        return this.prefix;
    }

    public boolean profileSpecificSources() {
        return this.includeProfileSpecificSources;
    }

    @Override
    public NormalizedSourceType type() {
        return NormalizedSourceType.LABELED_CONFIG_MAP;
    }

    @Override
    public String target() {
        return "configmap";
    }

    @Override
    public String toString() {
        return "{ config map labels : '" + String.valueOf(this.labels()) + "', namespace : '" + String.valueOf(this.namespace()) + "'";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LabeledConfigMapNormalizedSource other = (LabeledConfigMapNormalizedSource)o;
        return Objects.equals(this.labels(), other.labels()) && Objects.equals(this.namespace(), other.namespace());
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.labels(), this.namespace());
    }
}

