/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.commons.config.reload;

import java.util.Objects;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.kubernetes.commons.config.reload.ConfigurationUpdateStrategy;
import org.springframework.core.log.LogAccessor;

public abstract class ConfigurationChangeDetector {
    private static final LogAccessor LOG = new LogAccessor(LogFactory.getLog(ConfigurationChangeDetector.class));
    protected ConfigurationUpdateStrategy strategy;

    public ConfigurationChangeDetector(ConfigurationUpdateStrategy strategy) {
        this.strategy = Objects.requireNonNull(strategy);
    }

    public void reloadProperties() {
        LOG.info(() -> "Reloading using strategy: " + this.strategy.name());
        this.strategy.reloadProcedure().run();
    }
}

