/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.commons.config;

import org.springframework.boot.BootstrapContext;
import org.springframework.boot.BootstrapRegistryInitializer;
import org.springframework.boot.context.properties.bind.BindHandler;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.cloud.config.client.ConfigServerConfigDataLocationResolver;
import org.springframework.cloud.kubernetes.commons.KubernetesClientProperties;
import org.springframework.cloud.kubernetes.commons.discovery.KubernetesDiscoveryProperties;
import org.springframework.util.ClassUtils;

public abstract class KubernetesConfigServerBootstrapper
implements BootstrapRegistryInitializer {
    public static boolean hasConfigServerInstanceProvider() {
        return !ClassUtils.isPresent((String)"org.springframework.cloud.config.client.ConfigServerInstanceProvider", null);
    }

    public static KubernetesDiscoveryProperties createKubernetesDiscoveryProperties(BootstrapContext bootstrapContext) {
        ConfigServerConfigDataLocationResolver.PropertyResolver propertyResolver = KubernetesConfigServerBootstrapper.getPropertyResolver(bootstrapContext);
        return (KubernetesDiscoveryProperties)propertyResolver.resolveConfigurationProperties("spring.cloud.kubernetes.discovery", KubernetesDiscoveryProperties.class, () -> KubernetesDiscoveryProperties.DEFAULT);
    }

    public static KubernetesClientProperties createKubernetesClientProperties(BootstrapContext bootstrapContext) {
        ConfigServerConfigDataLocationResolver.PropertyResolver propertyResolver = KubernetesConfigServerBootstrapper.getPropertyResolver(bootstrapContext);
        return ((KubernetesClientProperties)KubernetesConfigServerBootstrapper.getPropertyResolver(bootstrapContext).resolveOrCreateConfigurationProperties("spring.cloud.kubernetes.client", KubernetesClientProperties.class)).withNamespace((String)propertyResolver.get("spring.cloud.kubernetes.client.namespace", String.class, null));
    }

    public static Boolean getDiscoveryEnabled(Binder binder, BindHandler bindHandler) {
        return (Boolean)binder.bind("spring.cloud.config.discovery.enabled", Bindable.of(Boolean.class), bindHandler).orElse((Object)false);
    }

    public static Boolean getDiscoveryEnabled(BootstrapContext bootstrapContext) {
        return (Boolean)KubernetesConfigServerBootstrapper.getPropertyResolver(bootstrapContext).get("spring.cloud.config.discovery.enabled", Boolean.class, (Object)false);
    }

    protected static ConfigServerConfigDataLocationResolver.PropertyResolver getPropertyResolver(BootstrapContext context) {
        return (ConfigServerConfigDataLocationResolver.PropertyResolver)context.getOrElseSupply(ConfigServerConfigDataLocationResolver.PropertyResolver.class, () -> new ConfigServerConfigDataLocationResolver.PropertyResolver((Binder)context.get(Binder.class), (BindHandler)context.getOrElse(BindHandler.class, null)));
    }
}

