/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.commons.discovery;

import jakarta.annotation.PostConstruct;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.client.discovery.event.InstanceRegisteredEvent;
import org.springframework.cloud.kubernetes.commons.PodUtils;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.core.log.LogAccessor;

public final class KubernetesDiscoveryClientHealthIndicatorInitializer {
    private static final LogAccessor LOG = new LogAccessor(LogFactory.getLog(KubernetesDiscoveryClientHealthIndicatorInitializer.class));
    private final PodUtils<?> podUtils;
    private final ApplicationEventPublisher applicationEventPublisher;

    public KubernetesDiscoveryClientHealthIndicatorInitializer(PodUtils<?> podUtils, ApplicationEventPublisher applicationEventPublisher) {
        this.podUtils = podUtils;
        this.applicationEventPublisher = applicationEventPublisher;
    }

    @PostConstruct
    private void postConstruct() {
        LOG.debug(() -> "publishing InstanceRegisteredEvent");
        InstanceRegisteredEvent instanceRegisteredEvent = new InstanceRegisteredEvent((Object)new RegisteredEventSource("kubernetes", this.podUtils.isInsideKubernetes(), this.podUtils.currentPod().get()), null);
        this.applicationEventPublisher.publishEvent((ApplicationEvent)instanceRegisteredEvent);
    }

    public record RegisteredEventSource(String cloudPlatform, boolean inside, Object pod) {
    }
}

