/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.commons.config;

import java.util.LinkedHashSet;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.kubernetes.commons.config.ConfigUtils;
import org.springframework.cloud.kubernetes.commons.config.MultipleSourcesContainer;
import org.springframework.cloud.kubernetes.commons.config.PrefixContext;
import org.springframework.cloud.kubernetes.commons.config.SourceData;

public abstract class NamedSourceData {
    private static final Log LOG = LogFactory.getLog(NamedSourceData.class);

    public final SourceData compute(String sourceName, ConfigUtils.Prefix prefix, String target, boolean profileSources, boolean failFast, String namespace, String[] activeProfiles) {
        LinkedHashSet<String> sourceNames = new LinkedHashSet<String>();
        sourceNames.add(sourceName);
        MultipleSourcesContainer data = MultipleSourcesContainer.empty();
        try {
            if (profileSources) {
                for (String activeProfile : activeProfiles) {
                    sourceNames.add(sourceName + "-" + activeProfile);
                }
            }
            if ((data = this.dataSupplier(sourceNames)).names().isEmpty()) {
                String emptySourceName = ConfigUtils.sourceName(target, sourceName, namespace);
                LOG.debug((Object)("Will return empty source with name : " + emptySourceName));
                return SourceData.emptyRecord(emptySourceName);
            }
            if (prefix != ConfigUtils.Prefix.DEFAULT) {
                String prefixToUse = prefix.prefixProvider().get();
                PrefixContext prefixContext = new PrefixContext(data.data(), prefixToUse, namespace, data.names());
                return ConfigUtils.withPrefix(target, prefixContext);
            }
        }
        catch (Exception e) {
            LOG.warn((Object)"Failure in reading named sources");
            ConfigUtils.onException(failFast, e);
            data = new MultipleSourcesContainer(data.names(), Map.of("spring.cloud.k8s.error.reading.property.source", "true"));
        }
        String names = data.names().stream().sorted().collect(Collectors.joining("."));
        return new SourceData(this.generateSourceName(target, names, namespace, activeProfiles), data.data());
    }

    protected String generateSourceName(String target, String sourceName, String namespace, String[] activeProfiles) {
        return ConfigUtils.sourceName(target, sourceName, namespace);
    }

    public abstract MultipleSourcesContainer dataSupplier(LinkedHashSet<String> var1);
}

