/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.commons.loadbalancer;

import java.util.Map;
import java.util.StringJoiner;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.kubernetes.commons.config.ConfigUtils;
import org.springframework.cloud.kubernetes.commons.discovery.KubernetesServiceInstance;
import org.springframework.core.log.LogAccessor;
import org.springframework.util.StringUtils;

public interface KubernetesServiceInstanceMapper<T> {
    public static final LogAccessor LOG = new LogAccessor(LogFactory.getLog(KubernetesServiceInstanceMapper.class));

    public KubernetesServiceInstance map(T var1);

    public static String createHost(String serviceName, String namespace, String clusterDomain) {
        String namespaceToUse = StringUtils.hasText((String)namespace) ? namespace : "default";
        return new StringJoiner(".").add(serviceName).add(namespaceToUse).add("svc").add(clusterDomain).toString();
    }

    public static boolean isSecure(Map<String, String> labels, Map<String, String> annotations, String servicePortName, Integer servicePort) {
        if (KubernetesServiceInstanceMapper.hasTrueSecuredValue(labels)) {
            LOG.debug(() -> "Service has a true 'secured' label");
            return true;
        }
        if (KubernetesServiceInstanceMapper.hasTrueSecuredValue(annotations)) {
            LOG.debug(() -> "Service has a true 'secured' annotation");
            return true;
        }
        if (servicePortName != null && servicePortName.endsWith("https")) {
            LOG.debug(() -> "Service port name ends with 'https'");
            return true;
        }
        if (servicePort != null && servicePort.toString().endsWith("443")) {
            LOG.debug(() -> "Service port ends with '443'");
            return true;
        }
        return false;
    }

    public static Map<String, String> getMapWithPrefixedKeys(Map<String, String> map, String prefix) {
        return ConfigUtils.keysWithPrefix(map, prefix);
    }

    private static boolean hasTrueSecuredValue(Map<String, String> input) {
        if (input != null) {
            return "true".equals(input.get("secured"));
        }
        return false;
    }
}

