/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.commons.config;

import java.io.IOException;
import java.util.ArrayList;
import org.springframework.boot.ConfigurableBootstrapContext;
import org.springframework.boot.context.config.ConfigData;
import org.springframework.boot.context.config.ConfigDataLoader;
import org.springframework.boot.context.config.ConfigDataLoaderContext;
import org.springframework.boot.context.config.ConfigDataResourceNotFoundException;
import org.springframework.cloud.kubernetes.commons.config.ConfigMapPropertySourceLocator;
import org.springframework.cloud.kubernetes.commons.config.KubernetesConfigDataResource;
import org.springframework.cloud.kubernetes.commons.config.SecretsPropertySourceLocator;
import org.springframework.core.Ordered;
import org.springframework.core.env.Environment;

public class KubernetesConfigDataLoader
implements ConfigDataLoader<KubernetesConfigDataResource>,
Ordered {
    public ConfigData load(ConfigDataLoaderContext context, KubernetesConfigDataResource resource) throws IOException, ConfigDataResourceNotFoundException {
        ArrayList propertySources = new ArrayList(2);
        ConfigurableBootstrapContext bootstrapContext = context.getBootstrapContext();
        Environment env = resource.getEnvironment();
        if (bootstrapContext.isRegistered(ConfigMapPropertySourceLocator.class)) {
            propertySources.add(((ConfigMapPropertySourceLocator)bootstrapContext.get(ConfigMapPropertySourceLocator.class)).locate(env));
        }
        if (bootstrapContext.isRegistered(SecretsPropertySourceLocator.class)) {
            propertySources.add(((SecretsPropertySourceLocator)bootstrapContext.get(SecretsPropertySourceLocator.class)).locate(env));
        }
        return new ConfigData(propertySources, propertySource -> {
            String propertySourceName = propertySource.getName();
            ArrayList<ConfigData.Option> options = new ArrayList<ConfigData.Option>();
            options.add(ConfigData.Option.IGNORE_IMPORTS);
            options.add(ConfigData.Option.IGNORE_PROFILES);
            for (String profile : resource.getAcceptedProfiles()) {
                if (!propertySourceName.matches(".*[-,]" + profile + ".*")) continue;
                options.add(ConfigData.Option.PROFILE_SPECIFIC);
            }
            return ConfigData.Options.of((ConfigData.Option[])options.toArray(new ConfigData.Option[0]));
        });
    }

    public int getOrder() {
        return -1;
    }
}

