/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.client.discovery;

import io.kubernetes.client.informer.SharedInformer;
import io.kubernetes.client.informer.SharedInformerFactory;
import io.kubernetes.client.informer.cache.Lister;
import io.kubernetes.client.openapi.apis.CoreV1Api;
import io.kubernetes.client.openapi.models.V1EndpointAddress;
import io.kubernetes.client.openapi.models.V1EndpointSubset;
import io.kubernetes.client.openapi.models.V1Endpoints;
import io.kubernetes.client.openapi.models.V1Service;
import jakarta.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.kubernetes.client.discovery.KubernetesClientDiscoveryClientUtils;
import org.springframework.cloud.kubernetes.client.discovery.KubernetesClientInstanceIdHostPodNameSupplier;
import org.springframework.cloud.kubernetes.client.discovery.KubernetesClientPodLabelsAndAnnotationsSupplier;
import org.springframework.cloud.kubernetes.commons.discovery.DiscoveryClientUtils;
import org.springframework.cloud.kubernetes.commons.discovery.KubernetesDiscoveryProperties;
import org.springframework.cloud.kubernetes.commons.discovery.ServiceMetadata;
import org.springframework.cloud.kubernetes.commons.discovery.ServicePortNameAndNumber;
import org.springframework.cloud.kubernetes.commons.discovery.ServicePortSecureResolver;
import org.springframework.core.log.LogAccessor;

abstract class KubernetesClientBlockingAbstractInformerDiscoveryClient
implements DiscoveryClient {
    private static final LogAccessor LOG = new LogAccessor(LogFactory.getLog(KubernetesClientBlockingAbstractInformerDiscoveryClient.class));
    private final List<SharedInformerFactory> sharedInformerFactories;
    private final List<Lister<V1Service>> serviceListers;
    private final List<Lister<V1Endpoints>> endpointsListers;
    private final Supplier<Boolean> informersReadyFunc;
    private final KubernetesDiscoveryProperties properties;
    private final Predicate<V1Service> predicate;
    private final ServicePortSecureResolver servicePortSecureResolver;
    private final CoreV1Api coreV1Api;

    KubernetesClientBlockingAbstractInformerDiscoveryClient(List<SharedInformerFactory> sharedInformerFactories, List<Lister<V1Service>> serviceListers, List<Lister<V1Endpoints>> endpointsListers, List<SharedInformer<V1Service>> serviceInformers, List<SharedInformer<V1Endpoints>> endpointsInformers, KubernetesDiscoveryProperties properties, CoreV1Api coreV1Api, Predicate<V1Service> predicate) {
        this.sharedInformerFactories = sharedInformerFactories;
        this.serviceListers = serviceListers;
        this.endpointsListers = endpointsListers;
        this.coreV1Api = coreV1Api;
        this.properties = properties;
        this.predicate = predicate;
        this.servicePortSecureResolver = new ServicePortSecureResolver(properties);
        this.informersReadyFunc = () -> {
            boolean serviceInformersReady = serviceInformers.isEmpty() || serviceInformers.stream().map(SharedInformer::hasSynced).reduce(Boolean::logicalAnd).orElse(false) != false;
            boolean endpointsInformersReady = endpointsInformers.isEmpty() || endpointsInformers.stream().map(SharedInformer::hasSynced).reduce(Boolean::logicalAnd).orElse(false) != false;
            return serviceInformersReady && endpointsInformersReady;
        };
    }

    public List<String> getServices() {
        List<String> services = this.serviceListers.stream().flatMap(serviceLister -> serviceLister.list().stream()).filter(service -> KubernetesClientDiscoveryClientUtils.matchesServiceLabels(service, this.properties)).filter(this.predicate).map(s -> s.getMetadata().getName()).distinct().toList();
        LOG.debug(() -> "will return services : " + String.valueOf(services));
        return services;
    }

    public List<ServiceInstance> getInstances(String serviceId) {
        Objects.requireNonNull(serviceId, "serviceId must be provided");
        List<V1Service> allServices = this.serviceListers.stream().flatMap(x -> x.list().stream()).filter(scv -> scv.getMetadata() != null).filter(svc -> serviceId.equals(svc.getMetadata().getName())).filter(scv -> KubernetesClientDiscoveryClientUtils.matchesServiceLabels(scv, this.properties)).toList();
        List serviceInstances = allServices.stream().filter(this.predicate).flatMap(service -> this.serviceInstances((V1Service)service, serviceId).stream()).collect(Collectors.toCollection(ArrayList::new));
        if (this.properties.includeExternalNameServices()) {
            LOG.debug(() -> "Searching for 'ExternalName' type of services with serviceId : " + serviceId);
            List<V1Service> externalNameServices = allServices.stream().filter(s -> s.getSpec() != null).filter(s -> "ExternalName".equals(s.getSpec().getType())).toList();
            for (V1Service service2 : externalNameServices) {
                ServiceMetadata serviceMetadata = KubernetesClientDiscoveryClientUtils.serviceMetadata(service2);
                Map serviceInstanceMetadata = DiscoveryClientUtils.serviceInstanceMetadata(Map.of(), (ServiceMetadata)serviceMetadata, (KubernetesDiscoveryProperties)this.properties);
                KubernetesClientInstanceIdHostPodNameSupplier supplierOne = KubernetesClientInstanceIdHostPodNameSupplier.externalName(service2);
                ServiceInstance externalNameServiceInstance = DiscoveryClientUtils.externalNameServiceInstance((ServiceMetadata)serviceMetadata, (Supplier)supplierOne, (Map)serviceInstanceMetadata);
                serviceInstances.add(externalNameServiceInstance);
            }
        }
        return serviceInstances;
    }

    public abstract String description();

    public int getOrder() {
        return this.properties.order();
    }

    @PostConstruct
    void afterPropertiesSet() {
        KubernetesClientDiscoveryClientUtils.postConstruct(this.sharedInformerFactories, this.properties, this.informersReadyFunc, this.serviceListers);
    }

    private List<ServiceInstance> serviceInstances(V1Service service, String serviceId) {
        ArrayList<ServiceInstance> instances = new ArrayList<ServiceInstance>();
        List<V1Endpoints> allEndpoints = this.endpointsListers.stream().map(endpointsLister -> (V1Endpoints)endpointsLister.namespace(service.getMetadata().getNamespace()).get(serviceId)).filter(Objects::nonNull).toList();
        for (V1Endpoints endpoints : allEndpoints) {
            List subsets = endpoints.getSubsets();
            if (subsets == null || subsets.isEmpty()) {
                LOG.debug(() -> "serviceId : " + serviceId + " does not have any subsets");
                continue;
            }
            ServiceMetadata serviceMetadata = KubernetesClientDiscoveryClientUtils.serviceMetadata(service);
            Map<String, Integer> portsData = KubernetesClientDiscoveryClientUtils.endpointSubsetsPortData(subsets);
            Map serviceInstanceMetadata = DiscoveryClientUtils.serviceInstanceMetadata(portsData, (ServiceMetadata)serviceMetadata, (KubernetesDiscoveryProperties)this.properties);
            for (V1EndpointSubset endpointSubset : subsets) {
                Map<String, Integer> endpointsPortData = KubernetesClientDiscoveryClientUtils.endpointSubsetsPortData(List.of(endpointSubset));
                ServicePortNameAndNumber portData = DiscoveryClientUtils.endpointsPort(endpointsPortData, (ServiceMetadata)serviceMetadata, (KubernetesDiscoveryProperties)this.properties);
                List<V1EndpointAddress> addresses = KubernetesClientDiscoveryClientUtils.addresses(endpointSubset, this.properties);
                for (V1EndpointAddress endpointAddress : addresses) {
                    KubernetesClientInstanceIdHostPodNameSupplier supplierOne = KubernetesClientInstanceIdHostPodNameSupplier.nonExternalName(endpointAddress, service);
                    KubernetesClientPodLabelsAndAnnotationsSupplier supplierTwo = KubernetesClientPodLabelsAndAnnotationsSupplier.nonExternalName(this.coreV1Api, service.getMetadata().getNamespace());
                    ServiceInstance serviceInstance = DiscoveryClientUtils.serviceInstance((ServicePortSecureResolver)this.servicePortSecureResolver, (ServiceMetadata)serviceMetadata, (Supplier)supplierOne, (Function)supplierTwo, (ServicePortNameAndNumber)portData, (Map)serviceInstanceMetadata, (KubernetesDiscoveryProperties)this.properties);
                    instances.add(serviceInstance);
                }
            }
        }
        return instances;
    }
}

