/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.client.discovery;

import io.kubernetes.client.informer.SharedInformer;
import io.kubernetes.client.informer.SharedInformerFactory;
import io.kubernetes.client.informer.cache.Lister;
import io.kubernetes.client.openapi.models.CoreV1EndpointPort;
import io.kubernetes.client.openapi.models.V1Endpoints;
import io.kubernetes.client.openapi.models.V1Service;
import jakarta.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.kubernetes.client.discovery.KubernetesDiscoveryClientUtils;
import org.springframework.cloud.kubernetes.commons.discovery.DefaultKubernetesServiceInstance;
import org.springframework.cloud.kubernetes.commons.discovery.KubernetesDiscoveryProperties;
import org.springframework.core.log.LogAccessor;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class KubernetesInformerDiscoveryClient
implements DiscoveryClient {
    private static final LogAccessor LOG = new LogAccessor(LogFactory.getLog(KubernetesInformerDiscoveryClient.class));
    private final List<SharedInformerFactory> sharedInformerFactories;
    private final List<Lister<V1Service>> serviceListers;
    private final List<Lister<V1Endpoints>> endpointsListers;
    private final Supplier<Boolean> informersReadyFunc;
    private final KubernetesDiscoveryProperties properties;
    private final Predicate<V1Service> filter;

    @Deprecated(forRemoval=true)
    public KubernetesInformerDiscoveryClient(String namespace, SharedInformerFactory sharedInformerFactory, Lister<V1Service> serviceLister, Lister<V1Endpoints> endpointsLister, SharedInformer<V1Service> serviceInformer, SharedInformer<V1Endpoints> endpointsInformer, KubernetesDiscoveryProperties properties) {
        this.sharedInformerFactories = List.of(sharedInformerFactory);
        this.serviceListers = List.of(serviceLister);
        this.endpointsListers = List.of(endpointsLister);
        this.informersReadyFunc = () -> serviceInformer.hasSynced() && endpointsInformer.hasSynced();
        this.properties = properties;
        this.filter = KubernetesDiscoveryClientUtils.filter(properties);
    }

    public KubernetesInformerDiscoveryClient(SharedInformerFactory sharedInformerFactory, Lister<V1Service> serviceLister, Lister<V1Endpoints> endpointsLister, SharedInformer<V1Service> serviceInformer, SharedInformer<V1Endpoints> endpointsInformer, KubernetesDiscoveryProperties properties) {
        this.sharedInformerFactories = List.of(sharedInformerFactory);
        this.serviceListers = List.of(serviceLister);
        this.endpointsListers = List.of(endpointsLister);
        this.informersReadyFunc = () -> serviceInformer.hasSynced() && endpointsInformer.hasSynced();
        this.properties = properties;
        this.filter = KubernetesDiscoveryClientUtils.filter(properties);
    }

    public KubernetesInformerDiscoveryClient(List<SharedInformerFactory> sharedInformerFactories, List<Lister<V1Service>> serviceListers, List<Lister<V1Endpoints>> endpointsListers, List<SharedInformer<V1Service>> serviceInformers, List<SharedInformer<V1Endpoints>> endpointsInformers, KubernetesDiscoveryProperties properties) {
        this.sharedInformerFactories = sharedInformerFactories;
        this.serviceListers = serviceListers;
        this.endpointsListers = endpointsListers;
        this.informersReadyFunc = () -> {
            boolean serviceInformersReady = serviceInformers.isEmpty() || serviceInformers.stream().map(SharedInformer::hasSynced).reduce(Boolean::logicalAnd).orElse(false) != false;
            boolean endpointsInformersReady = endpointsInformers.isEmpty() || endpointsInformers.stream().map(SharedInformer::hasSynced).reduce(Boolean::logicalAnd).orElse(false) != false;
            return serviceInformersReady && endpointsInformersReady;
        };
        this.properties = properties;
        this.filter = KubernetesDiscoveryClientUtils.filter(properties);
    }

    public String description() {
        return "Kubernetes Client Discovery";
    }

    public List<ServiceInstance> getInstances(String serviceId) {
        Objects.requireNonNull(serviceId, "serviceId must be provided");
        List<V1Service> services = this.serviceListers.stream().flatMap(x -> x.list().stream()).filter(scv -> scv.getMetadata() != null).filter(svc -> serviceId.equals(svc.getMetadata().getName())).filter(this.filter).toList();
        if (services.size() == 0 || services.stream().noneMatch(service -> KubernetesDiscoveryClientUtils.matchesServiceLabels(service, this.properties))) {
            return List.of();
        }
        return services.stream().flatMap(service -> this.getServiceInstanceDetails((V1Service)service, serviceId)).toList();
    }

    private Stream<ServiceInstance> getServiceInstanceDetails(V1Service service, String serviceId) {
        Map<String, String> serviceMetadata = KubernetesDiscoveryClientUtils.serviceMetadata(this.properties, service, serviceId);
        List<V1Endpoints> endpoints = this.endpointsListers.stream().map(endpointsLister -> (V1Endpoints)endpointsLister.namespace(service.getMetadata().getNamespace()).get(service.getMetadata().getName())).filter(Objects::nonNull).filter(ep -> ep.getSubsets() != null).toList();
        Optional<String> discoveredPrimaryPortName = Optional.empty();
        if (service.getMetadata() != null && service.getMetadata().getLabels() != null) {
            discoveredPrimaryPortName = Optional.ofNullable((String)service.getMetadata().getLabels().get("primary-port-name"));
        }
        String primaryPortName = discoveredPrimaryPortName.orElse(this.properties.primaryPortName());
        boolean secured = KubernetesInformerDiscoveryClient.isSecured(service);
        return endpoints.stream().flatMap(ep -> ep.getSubsets().stream().filter(subset -> subset.getPorts() != null && subset.getPorts().size() > 0).flatMap(subset -> {
            ArrayList addresses;
            HashMap metadata = new HashMap(serviceMetadata);
            List endpointPorts = subset.getPorts();
            if (this.properties.metadata() != null && this.properties.metadata().addPorts()) {
                endpointPorts.forEach(p -> metadata.put(StringUtils.hasText((String)p.getName()) ? p.getName() : "<unset>", Integer.toString(p.getPort())));
            }
            if ((addresses = subset.getAddresses()) == null) {
                addresses = new ArrayList();
            }
            if (this.properties.includeNotReadyAddresses() && !CollectionUtils.isEmpty((Collection)subset.getNotReadyAddresses())) {
                addresses.addAll(subset.getNotReadyAddresses());
            }
            int port = this.findEndpointPort(endpointPorts, primaryPortName, serviceId);
            return addresses.stream().map(addr -> new DefaultKubernetesServiceInstance(addr.getTargetRef() != null ? addr.getTargetRef().getUid() : "", serviceId, addr.getIp(), port, metadata, secured, service.getMetadata().getNamespace(), null));
        }));
    }

    private static boolean isSecured(V1Service service) {
        Optional<String> securedOpt = Optional.empty();
        if (service.getMetadata() != null && service.getMetadata().getAnnotations() != null) {
            securedOpt = Optional.ofNullable((String)service.getMetadata().getAnnotations().get("secured"));
        }
        if (!securedOpt.isPresent() && service.getMetadata() != null && service.getMetadata().getLabels() != null) {
            securedOpt = Optional.ofNullable((String)service.getMetadata().getLabels().get("secured"));
        }
        return Boolean.parseBoolean(securedOpt.orElse("false"));
    }

    private int findEndpointPort(List<CoreV1EndpointPort> endpointPorts, String primaryPortName, String serviceId) {
        if (endpointPorts.size() == 1) {
            return endpointPorts.get(0).getPort();
        }
        Map<String, Integer> ports = endpointPorts.stream().filter(p -> StringUtils.hasText((String)p.getName())).collect(Collectors.toMap(CoreV1EndpointPort::getName, CoreV1EndpointPort::getPort));
        int discoveredPort = ports.getOrDefault(primaryPortName, ports.getOrDefault("https", ports.getOrDefault("http", -1)));
        if (discoveredPort == -1) {
            if (StringUtils.hasText((String)primaryPortName)) {
                LOG.warn(() -> "Could not find a port named '" + primaryPortName + "', 'https', or 'http' for service '" + serviceId + "'.");
            } else {
                LOG.warn(() -> "Could not find a port named 'https' or 'http' for service '" + serviceId + "'.");
            }
            LOG.warn(() -> "Make sure that either the primary-port-name label has been added to the service, or that spring.cloud.kubernetes.discovery.primary-port-name has been configured.");
            LOG.warn(() -> "Alternatively name the primary port 'https' or 'http'");
            LOG.warn(() -> "An incorrect configuration may result in non-deterministic behaviour.");
            discoveredPort = endpointPorts.get(0).getPort();
        }
        return discoveredPort;
    }

    public List<String> getServices() {
        List<String> services = this.serviceListers.stream().flatMap(serviceLister -> serviceLister.list().stream()).filter(service -> KubernetesDiscoveryClientUtils.matchesServiceLabels(service, this.properties)).filter(this.filter).map(s -> s.getMetadata().getName()).distinct().toList();
        LOG.debug(() -> "will return services : " + services);
        return services;
    }

    @PostConstruct
    public void afterPropertiesSet() {
        KubernetesDiscoveryClientUtils.postConstruct(this.sharedInformerFactories, this.properties, this.informersReadyFunc, this.serviceListers);
    }

    public int getOrder() {
        return this.properties.order();
    }
}

