/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.client.discovery;

import io.kubernetes.client.openapi.models.V1ObjectMeta;
import io.kubernetes.client.openapi.models.V1Service;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.kubernetes.commons.discovery.KubernetesDiscoveryProperties;
import org.springframework.core.log.LogAccessor;

final class KubernetesDiscoveryClientUtils {
    private static final LogAccessor LOG = new LogAccessor(LogFactory.getLog(KubernetesDiscoveryClientUtils.class));

    private KubernetesDiscoveryClientUtils() {
    }

    static boolean matchesServiceLabels(V1Service service, KubernetesDiscoveryProperties properties) {
        Map propertiesServiceLabels = properties.serviceLabels();
        Map serviceLabels = Optional.ofNullable(service.getMetadata()).map(V1ObjectMeta::getLabels).orElse(Map.of());
        if (propertiesServiceLabels.isEmpty()) {
            LOG.debug(() -> "service labels from properties are empty, service with name : '" + service.getMetadata().getName() + "' will match");
            return true;
        }
        if (serviceLabels.isEmpty()) {
            LOG.debug(() -> "service with name : '" + service.getMetadata().getName() + "' does not have labels");
            return false;
        }
        LOG.debug(() -> "Service labels from properties : " + properties.serviceLabels());
        LOG.debug(() -> "Service labels from service : " + service.getMetadata().getLabels());
        return serviceLabels.keySet().containsAll(propertiesServiceLabels.keySet());
    }
}

