/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.client.discovery.reactive;

import io.kubernetes.client.informer.SharedInformer;
import io.kubernetes.client.informer.SharedInformerFactory;
import io.kubernetes.client.informer.cache.Lister;
import io.kubernetes.client.openapi.models.V1Endpoints;
import io.kubernetes.client.openapi.models.V1EndpointsList;
import io.kubernetes.client.openapi.models.V1Service;
import io.kubernetes.client.openapi.models.V1ServiceList;
import io.kubernetes.client.spring.extended.controller.annotation.GroupVersionResource;
import io.kubernetes.client.spring.extended.controller.annotation.KubernetesInformer;
import io.kubernetes.client.spring.extended.controller.annotation.KubernetesInformers;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnCloudPlatform;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.cloud.CloudPlatform;
import org.springframework.cloud.client.ConditionalOnDiscoveryEnabled;
import org.springframework.cloud.client.ConditionalOnDiscoveryHealthIndicatorEnabled;
import org.springframework.cloud.client.ConditionalOnReactiveDiscoveryEnabled;
import org.springframework.cloud.client.ReactiveCommonsClientAutoConfiguration;
import org.springframework.cloud.client.discovery.ReactiveDiscoveryClient;
import org.springframework.cloud.client.discovery.composite.reactive.ReactiveCompositeDiscoveryClientAutoConfiguration;
import org.springframework.cloud.client.discovery.event.InstanceRegisteredEvent;
import org.springframework.cloud.client.discovery.health.DiscoveryClientHealthIndicatorProperties;
import org.springframework.cloud.client.discovery.health.reactive.ReactiveDiscoveryClientHealthIndicator;
import org.springframework.cloud.client.discovery.simple.reactive.SimpleReactiveDiscoveryClientAutoConfiguration;
import org.springframework.cloud.kubernetes.client.KubernetesClientPodUtils;
import org.springframework.cloud.kubernetes.client.discovery.KubernetesDiscoveryClientAutoConfiguration;
import org.springframework.cloud.kubernetes.client.discovery.reactive.KubernetesInformerReactiveDiscoveryClient;
import org.springframework.cloud.kubernetes.commons.KubernetesNamespaceProvider;
import org.springframework.cloud.kubernetes.commons.discovery.ConditionalOnKubernetesDiscoveryEnabled;
import org.springframework.cloud.kubernetes.commons.discovery.KubernetesDiscoveryProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnDiscoveryEnabled
@ConditionalOnReactiveDiscoveryEnabled
@ConditionalOnCloudPlatform(value=CloudPlatform.KUBERNETES)
@ConditionalOnKubernetesDiscoveryEnabled
@AutoConfigureBefore(value={SimpleReactiveDiscoveryClientAutoConfiguration.class, ReactiveCommonsClientAutoConfiguration.class})
@AutoConfigureAfter(value={ReactiveCompositeDiscoveryClientAutoConfiguration.class, KubernetesDiscoveryClientAutoConfiguration.class})
public class KubernetesInformerReactiveDiscoveryClientAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public KubernetesInformerReactiveDiscoveryClient kubernetesReactiveDiscoveryClient(KubernetesNamespaceProvider kubernetesNamespaceProvider, SharedInformerFactory sharedInformerFactory, Lister<V1Service> serviceLister, Lister<V1Endpoints> endpointsLister, SharedInformer<V1Service> serviceInformer, SharedInformer<V1Endpoints> endpointsInformer, KubernetesDiscoveryProperties properties) {
        return new KubernetesInformerReactiveDiscoveryClient(kubernetesNamespaceProvider, sharedInformerFactory, serviceLister, endpointsLister, serviceInformer, endpointsInformer, properties);
    }

    @Bean
    @ConditionalOnClass(name={"org.springframework.boot.actuate.health.ReactiveHealthIndicator"})
    @ConditionalOnDiscoveryHealthIndicatorEnabled
    public ReactiveDiscoveryClientHealthIndicator kubernetesReactiveDiscoveryClientHealthIndicator(KubernetesInformerReactiveDiscoveryClient client, DiscoveryClientHealthIndicatorProperties properties, KubernetesClientPodUtils podUtils) {
        ReactiveDiscoveryClientHealthIndicator healthIndicator = new ReactiveDiscoveryClientHealthIndicator((ReactiveDiscoveryClient)client, properties);
        InstanceRegisteredEvent event = new InstanceRegisteredEvent((Object)podUtils.currentPod(), null);
        healthIndicator.onApplicationEvent(event);
        return healthIndicator;
    }

    @KubernetesInformers(value={@KubernetesInformer(apiTypeClass=V1Service.class, apiListTypeClass=V1ServiceList.class, groupVersionResource=@GroupVersionResource(apiGroup="", apiVersion="v1", resourcePlural="services")), @KubernetesInformer(apiTypeClass=V1Endpoints.class, apiListTypeClass=V1EndpointsList.class, groupVersionResource=@GroupVersionResource(apiGroup="", apiVersion="v1", resourcePlural="endpoints"))})
    class CatalogSharedInformerFactory
    extends SharedInformerFactory {
        CatalogSharedInformerFactory() {
        }
    }
}

