/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.client.config;

import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.openapi.apis.CoreV1Api;
import io.kubernetes.client.openapi.models.V1ConfigMap;
import io.kubernetes.client.openapi.models.V1Secret;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.kubernetes.client.config.KubernetesClientConfigUtils;
import org.springframework.cloud.kubernetes.commons.config.StrippedSourceContainer;
import org.springframework.core.log.LogAccessor;

final class KubernetesClientSourcesSingleRead {
    private static final LogAccessor LOG = new LogAccessor(LogFactory.getLog(KubernetesClientSourcesSingleRead.class));

    private KubernetesClientSourcesSingleRead() {
    }

    static List<StrippedSourceContainer> strippedConfigMaps(CoreV1Api client, String namespace, LinkedHashSet<String> sourceNames) {
        ArrayList<V1ConfigMap> configMaps = new ArrayList<V1ConfigMap>(sourceNames.size());
        for (String sourceName : sourceNames) {
            V1ConfigMap configMap = null;
            try {
                configMap = client.readNamespacedConfigMap(sourceName, namespace).execute();
            }
            catch (ApiException e) {
                KubernetesClientConfigUtils.handleApiException(e, sourceName);
            }
            if (configMap == null) continue;
            LOG.debug((CharSequence)("Loaded config map '" + sourceName + "'"));
            configMaps.add(configMap);
        }
        List<StrippedSourceContainer> strippedConfigMaps = KubernetesClientConfigUtils.stripConfigMaps(configMaps);
        if (strippedConfigMaps.isEmpty()) {
            LOG.debug((CharSequence)("No configmaps in namespace '" + namespace + "'"));
        }
        return strippedConfigMaps;
    }

    static List<StrippedSourceContainer> strippedSecrets(CoreV1Api client, String namespace, LinkedHashSet<String> sourceNames) {
        ArrayList<V1Secret> secrets = new ArrayList<V1Secret>(sourceNames.size());
        for (String sourceName : sourceNames) {
            V1Secret secret = null;
            try {
                secret = client.readNamespacedSecret(sourceName, namespace).execute();
            }
            catch (ApiException e) {
                KubernetesClientConfigUtils.handleApiException(e, sourceName);
            }
            if (secret == null) continue;
            LOG.debug(() -> "Loaded config map '" + sourceName + "'");
            secrets.add(secret);
        }
        List<StrippedSourceContainer> strippedSecrets = KubernetesClientConfigUtils.stripSecrets(secrets);
        if (strippedSecrets.isEmpty()) {
            LOG.debug(() -> "No secrets in namespace '" + namespace + "'");
        }
        return strippedSecrets;
    }

    static List<StrippedSourceContainer> strippedConfigMaps(CoreV1Api client, String namespace, Map<String, String> labels) {
        List configMaps;
        try {
            configMaps = client.listNamespacedConfigMap(namespace).labelSelector(KubernetesClientSourcesSingleRead.labelSelector(labels)).execute().getItems();
        }
        catch (ApiException e) {
            throw new RuntimeException(e.getResponseBody(), e);
        }
        for (V1ConfigMap configMap : configMaps) {
            LOG.debug(() -> "Loaded config map '" + configMap.getMetadata().getName() + "'");
        }
        List<StrippedSourceContainer> strippedConfigMaps = KubernetesClientConfigUtils.stripConfigMaps(configMaps);
        if (strippedConfigMaps.isEmpty()) {
            LOG.debug(() -> "No configmaps in namespace '" + namespace + "'");
        }
        return strippedConfigMaps;
    }

    static List<StrippedSourceContainer> strippedSecrets(CoreV1Api client, String namespace, Map<String, String> labels) {
        List secrets;
        try {
            secrets = client.listNamespacedSecret(namespace).labelSelector(KubernetesClientSourcesSingleRead.labelSelector(labels)).execute().getItems();
        }
        catch (ApiException e) {
            throw new RuntimeException(e.getResponseBody(), e);
        }
        for (V1Secret secret : secrets) {
            LOG.debug(() -> "Loaded secret '" + secret.getMetadata().getName() + "'");
        }
        List<StrippedSourceContainer> strippedSecrets = KubernetesClientConfigUtils.stripSecrets(secrets);
        if (strippedSecrets.isEmpty()) {
            LOG.debug(() -> "No secrets in namespace '" + namespace + "'");
        }
        return strippedSecrets;
    }

    private static String labelSelector(Map<String, String> labels) {
        return labels.entrySet().stream().map(en -> (String)en.getKey() + "=" + (String)en.getValue()).collect(Collectors.joining("&"));
    }
}

