/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.client.config;

import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.openapi.apis.CoreV1Api;
import io.kubernetes.client.openapi.models.V1ConfigMap;
import io.kubernetes.client.openapi.models.V1Secret;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.kubernetes.client.KubernetesClientUtils;
import org.springframework.cloud.kubernetes.client.config.KubernetesClientSourcesBatchRead;
import org.springframework.cloud.kubernetes.client.config.KubernetesClientSourcesSingleRead;
import org.springframework.cloud.kubernetes.commons.KubernetesNamespaceProvider;
import org.springframework.cloud.kubernetes.commons.config.ConfigUtils;
import org.springframework.cloud.kubernetes.commons.config.MultipleSourcesContainer;
import org.springframework.cloud.kubernetes.commons.config.ReadType;
import org.springframework.cloud.kubernetes.commons.config.StrippedSourceContainer;
import org.springframework.cloud.kubernetes.commons.config.reload.ConfigReloadProperties;
import org.springframework.core.env.Environment;
import org.springframework.core.log.LogAccessor;
import org.springframework.util.ObjectUtils;

public final class KubernetesClientConfigUtils {
    private static final LogAccessor LOG = new LogAccessor(LogFactory.getLog(KubernetesClientConfigUtils.class));

    private KubernetesClientConfigUtils() {
    }

    public static Set<String> namespaces(KubernetesNamespaceProvider provider, ConfigReloadProperties properties, String target) {
        Set<String> namespaces = properties.namespaces();
        if (namespaces.isEmpty()) {
            namespaces = Set.of(KubernetesClientUtils.getApplicationNamespace(null, (String)target, (KubernetesNamespaceProvider)provider));
        }
        LOG.debug((CharSequence)("informer namespaces : " + String.valueOf(namespaces)));
        return namespaces;
    }

    static MultipleSourcesContainer configMapsByName(CoreV1Api client, String namespace, LinkedHashSet<String> sourceNames, Environment environment, boolean includeDefaultProfileData, ReadType readType) {
        List<StrippedSourceContainer> strippedConfigMaps;
        if (readType.equals((Object)ReadType.BATCH)) {
            LOG.debug(() -> "Will read all configmaps in namespace : " + namespace);
            strippedConfigMaps = KubernetesClientSourcesBatchRead.strippedConfigMaps(client, namespace);
        } else {
            LOG.debug(() -> "Will read individual configmaps in namespace : " + namespace + " with names : " + String.valueOf(sourceNames));
            strippedConfigMaps = KubernetesClientSourcesSingleRead.strippedConfigMaps(client, namespace, sourceNames);
        }
        return ConfigUtils.processNamedData(strippedConfigMaps, (Environment)environment, sourceNames, (String)namespace, (boolean)false, (boolean)includeDefaultProfileData);
    }

    static MultipleSourcesContainer secretsByName(CoreV1Api client, String namespace, LinkedHashSet<String> sourceNames, Environment environment, boolean includeDefaultProfileData, ReadType readType) {
        List<StrippedSourceContainer> strippedSecrets;
        if (readType.equals((Object)ReadType.BATCH)) {
            LOG.debug(() -> "Will read all secrets in namespace : " + namespace);
            strippedSecrets = KubernetesClientSourcesBatchRead.strippedSecrets(client, namespace);
        } else {
            LOG.debug(() -> "Will read individual secrets in namespace : " + namespace + " with names : " + String.valueOf(sourceNames));
            strippedSecrets = KubernetesClientSourcesSingleRead.strippedSecrets(client, namespace, sourceNames);
        }
        return ConfigUtils.processNamedData(strippedSecrets, (Environment)environment, sourceNames, (String)namespace, (boolean)false, (boolean)includeDefaultProfileData);
    }

    static MultipleSourcesContainer configMapsByLabels(CoreV1Api client, String namespace, Map<String, String> labels, Environment environment, ReadType readType) {
        List<StrippedSourceContainer> strippedConfigMaps;
        if (readType.equals((Object)ReadType.BATCH)) {
            LOG.debug(() -> "Will read all configmaps in namespace : " + namespace);
            strippedConfigMaps = KubernetesClientSourcesBatchRead.strippedConfigMaps(client, namespace);
        } else {
            LOG.debug(() -> "Will read individual configmaps in namespace : " + namespace + " with labels : " + String.valueOf(labels));
            strippedConfigMaps = KubernetesClientSourcesSingleRead.strippedConfigMaps(client, namespace, labels);
        }
        return ConfigUtils.processLabeledData(strippedConfigMaps, (Environment)environment, labels, (String)namespace, (boolean)false);
    }

    static MultipleSourcesContainer secretsByLabels(CoreV1Api client, String namespace, Map<String, String> labels, Environment environment, ReadType readType) {
        List<StrippedSourceContainer> strippedSecrets;
        if (readType.equals((Object)ReadType.BATCH)) {
            LOG.debug(() -> "Will read all secrets in namespace : " + namespace);
            strippedSecrets = KubernetesClientSourcesBatchRead.strippedSecrets(client, namespace);
        } else {
            LOG.debug(() -> "Will read individual secrets in namespace : " + namespace + " with labels : " + String.valueOf(labels));
            strippedSecrets = KubernetesClientSourcesSingleRead.strippedSecrets(client, namespace, labels);
        }
        return ConfigUtils.processLabeledData(strippedSecrets, (Environment)environment, labels, (String)namespace, (boolean)false);
    }

    static List<StrippedSourceContainer> stripSecrets(List<V1Secret> secrets) {
        return secrets.stream().map(secret -> new StrippedSourceContainer(secret.getMetadata().getLabels(), secret.getMetadata().getName(), KubernetesClientConfigUtils.transform(secret.getData()))).toList();
    }

    static List<StrippedSourceContainer> stripConfigMaps(List<V1ConfigMap> configMaps) {
        return configMaps.stream().map(configMap -> new StrippedSourceContainer(configMap.getMetadata().getLabels(), configMap.getMetadata().getName(), configMap.getData())).toList();
    }

    static void handleApiException(ApiException e, String sourceName) {
        if (e.getCode() != 404) {
            throw new RuntimeException(e.getResponseBody(), e);
        }
        LOG.warn(() -> "source with name : " + sourceName + " not found. Ignoring");
    }

    private static Map<String, String> transform(Map<String, byte[]> in) {
        return ObjectUtils.isEmpty(in) ? Map.of() : in.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, en -> new String((byte[])en.getValue())));
    }
}

