/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.client.config;

import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.openapi.apis.CoreV1Api;
import io.kubernetes.client.openapi.models.V1ConfigMap;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.kubernetes.commons.config.ConfigMapCache;
import org.springframework.cloud.kubernetes.commons.config.StrippedSourceContainer;
import org.springframework.core.log.LogAccessor;

public final class KubernetesClientConfigMapsCache
implements ConfigMapCache {
    private static final LogAccessor LOG = new LogAccessor(LogFactory.getLog(KubernetesClientConfigMapsCache.class));
    private static final ConcurrentHashMap<String, List<StrippedSourceContainer>> CACHE = new ConcurrentHashMap();

    public void discardAll() {
        CACHE.clear();
    }

    static List<StrippedSourceContainer> byNamespace(CoreV1Api coreV1Api, String namespace) {
        boolean[] b = new boolean[1];
        List result = CACHE.computeIfAbsent(namespace, x -> {
            try {
                b[0] = true;
                return KubernetesClientConfigMapsCache.strippedConfigMaps(coreV1Api.listNamespacedConfigMap(namespace, null, null, null, null, null, null, null, null, null, null, null).getItems());
            }
            catch (ApiException apiException) {
                throw new RuntimeException(apiException.getResponseBody(), apiException);
            }
        });
        if (b[0]) {
            LOG.debug(() -> "Loaded all config maps in namespace '" + namespace + "'");
        } else {
            LOG.debug(() -> "Loaded (from cache) all config maps in namespace '" + namespace + "'");
        }
        return result;
    }

    private static List<StrippedSourceContainer> strippedConfigMaps(List<V1ConfigMap> configMaps) {
        return configMaps.stream().map(configMap -> new StrippedSourceContainer(configMap.getMetadata().getLabels(), configMap.getMetadata().getName(), configMap.getData())).toList();
    }
}

