/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.client.config;

import io.kubernetes.client.openapi.apis.CoreV1Api;
import org.springframework.cloud.kubernetes.client.KubernetesClientUtils;
import org.springframework.cloud.kubernetes.client.config.KubernetesClientConfigContext;
import org.springframework.cloud.kubernetes.client.config.KubernetesClientConfigMapPropertySource;
import org.springframework.cloud.kubernetes.client.config.KubernetesClientConfigMapsCache;
import org.springframework.cloud.kubernetes.commons.KubernetesNamespaceProvider;
import org.springframework.cloud.kubernetes.commons.config.ConfigMapCache;
import org.springframework.cloud.kubernetes.commons.config.ConfigMapConfigProperties;
import org.springframework.cloud.kubernetes.commons.config.ConfigMapPropertySourceLocator;
import org.springframework.cloud.kubernetes.commons.config.NormalizedSource;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MapPropertySource;

@Order(value=0)
public class KubernetesClientConfigMapPropertySourceLocator
extends ConfigMapPropertySourceLocator {
    private final CoreV1Api coreV1Api;
    private final KubernetesNamespaceProvider kubernetesNamespaceProvider;

    public KubernetesClientConfigMapPropertySourceLocator(CoreV1Api coreV1Api, ConfigMapConfigProperties properties, KubernetesNamespaceProvider kubernetesNamespaceProvider) {
        super(properties, (ConfigMapCache)new KubernetesClientConfigMapsCache());
        this.coreV1Api = coreV1Api;
        this.kubernetesNamespaceProvider = kubernetesNamespaceProvider;
    }

    protected MapPropertySource getMapPropertySource(NormalizedSource source, ConfigurableEnvironment environment) {
        String normalizedNamespace = source.namespace().orElse(null);
        String namespace = KubernetesClientUtils.getApplicationNamespace((String)normalizedNamespace, (String)source.target(), (KubernetesNamespaceProvider)this.kubernetesNamespaceProvider);
        KubernetesClientConfigContext context = new KubernetesClientConfigContext(this.coreV1Api, source, namespace, (Environment)environment);
        return new KubernetesClientConfigMapPropertySource(context);
    }
}

