/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.client.config;

import io.kubernetes.client.openapi.apis.CoreV1Api;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.cloud.kubernetes.client.KubernetesClientAutoConfiguration;
import org.springframework.cloud.kubernetes.client.config.KubernetesClientConfigMapPropertySourceLocator;
import org.springframework.cloud.kubernetes.client.config.KubernetesClientSecretsPropertySourceLocator;
import org.springframework.cloud.kubernetes.commons.ConditionalOnKubernetesConfigEnabled;
import org.springframework.cloud.kubernetes.commons.ConditionalOnKubernetesEnabled;
import org.springframework.cloud.kubernetes.commons.ConditionalOnKubernetesSecretsEnabled;
import org.springframework.cloud.kubernetes.commons.KubernetesCommonsAutoConfiguration;
import org.springframework.cloud.kubernetes.commons.KubernetesNamespaceProvider;
import org.springframework.cloud.kubernetes.commons.config.ConditionalOnKubernetesConfigRetryDisabled;
import org.springframework.cloud.kubernetes.commons.config.ConditionalOnKubernetesSecretsRetryDisabled;
import org.springframework.cloud.kubernetes.commons.config.ConfigMapConfigProperties;
import org.springframework.cloud.kubernetes.commons.config.KubernetesBootstrapConfiguration;
import org.springframework.cloud.kubernetes.commons.config.SecretsConfigProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration(proxyBeanMethods=false)
@ConditionalOnKubernetesEnabled
@AutoConfigureAfter(value={KubernetesBootstrapConfiguration.class})
@Import(value={KubernetesCommonsAutoConfiguration.class, KubernetesClientAutoConfiguration.class})
public class KubernetesClientBootstrapConfiguration {
    @Bean
    @ConditionalOnKubernetesConfigEnabled
    @ConditionalOnKubernetesConfigRetryDisabled
    public KubernetesClientConfigMapPropertySourceLocator configMapPropertySourceLocator(ConfigMapConfigProperties properties, CoreV1Api coreV1Api, KubernetesNamespaceProvider kubernetesNamespaceProvider) {
        return new KubernetesClientConfigMapPropertySourceLocator(coreV1Api, properties, kubernetesNamespaceProvider);
    }

    @Bean
    @ConditionalOnKubernetesSecretsEnabled
    @ConditionalOnKubernetesSecretsRetryDisabled
    public KubernetesClientSecretsPropertySourceLocator secretsPropertySourceLocator(SecretsConfigProperties properties, CoreV1Api coreV1Api, KubernetesNamespaceProvider kubernetesNamespaceProvider) {
        return new KubernetesClientSecretsPropertySourceLocator(coreV1Api, kubernetesNamespaceProvider, properties);
    }
}

