/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.client.config.reload;

import io.kubernetes.client.informer.ResourceEventHandler;
import io.kubernetes.client.informer.SharedIndexInformer;
import io.kubernetes.client.informer.SharedInformerFactory;
import io.kubernetes.client.openapi.ApiClient;
import io.kubernetes.client.openapi.apis.CoreV1Api;
import io.kubernetes.client.openapi.models.V1ConfigMap;
import io.kubernetes.client.openapi.models.V1ConfigMapList;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import okhttp3.OkHttpClient;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.bootstrap.config.PropertySourceLocator;
import org.springframework.cloud.kubernetes.client.KubernetesClientUtils;
import org.springframework.cloud.kubernetes.client.config.KubernetesClientConfigMapPropertySource;
import org.springframework.cloud.kubernetes.client.config.KubernetesClientConfigMapPropertySourceLocator;
import org.springframework.cloud.kubernetes.commons.KubernetesClientProperties;
import org.springframework.cloud.kubernetes.commons.config.reload.ConfigReloadProperties;
import org.springframework.cloud.kubernetes.commons.config.reload.ConfigurationChangeDetector;
import org.springframework.cloud.kubernetes.commons.config.reload.ConfigurationUpdateStrategy;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;

public class KubernetesClientEventBasedConfigMapChangeDetector
extends ConfigurationChangeDetector {
    private static final Log LOG = LogFactory.getLog(KubernetesClientEventBasedConfigMapChangeDetector.class);
    private CoreV1Api coreV1Api = null;
    private KubernetesClientConfigMapPropertySourceLocator propertySourceLocator;
    private SharedInformerFactory factory;
    private KubernetesClientProperties kubernetesClientProperties;

    public KubernetesClientEventBasedConfigMapChangeDetector(CoreV1Api coreV1Api, ConfigurableEnvironment environment, ConfigReloadProperties properties, ConfigurationUpdateStrategy strategy, KubernetesClientConfigMapPropertySourceLocator propertySourceLocator, KubernetesClientProperties kubernetesClientProperties) {
        super(environment, properties, strategy);
        this.propertySourceLocator = propertySourceLocator;
        this.coreV1Api = coreV1Api;
        this.factory = new SharedInformerFactory();
        this.kubernetesClientProperties = kubernetesClientProperties;
    }

    public KubernetesClientEventBasedConfigMapChangeDetector(ConfigurableEnvironment environment, ConfigReloadProperties properties, ConfigurationUpdateStrategy strategy, KubernetesClientConfigMapPropertySourceLocator propertySourceLocator, KubernetesClientProperties kubernetesClientProperties) {
        super(environment, properties, strategy);
        this.propertySourceLocator = propertySourceLocator;
        this.kubernetesClientProperties = kubernetesClientProperties;
        try {
            ApiClient apiClient = KubernetesClientUtils.kubernetesApiClient();
            OkHttpClient httpClient = apiClient.getHttpClient().newBuilder().readTimeout(0L, TimeUnit.SECONDS).build();
            apiClient.setHttpClient(httpClient);
            this.coreV1Api = new CoreV1Api(apiClient);
        }
        catch (Exception e) {
            LOG.error((Object)"Failed to create Kubernetes API client.  Event based ConfigMap monitoring will not work", (Throwable)e);
        }
        this.factory = new SharedInformerFactory();
    }

    @PostConstruct
    public void watch() {
        if (this.coreV1Api != null && this.properties.isMonitoringConfigMaps()) {
            SharedIndexInformer configMapInformer = this.factory.sharedIndexInformerFor(params -> this.coreV1Api.listNamespacedConfigMapCall(this.kubernetesClientProperties.getNamespace(), null, null, null, null, null, null, params.resourceVersion, params.timeoutSeconds, params.watch, null), V1ConfigMap.class, V1ConfigMapList.class);
            configMapInformer.addEventHandler((ResourceEventHandler)new ResourceEventHandler<V1ConfigMap>(){

                public void onAdd(V1ConfigMap obj) {
                    LOG.info((Object)("CongifMap " + obj.getMetadata().getName() + " was added."));
                    KubernetesClientEventBasedConfigMapChangeDetector.this.onEvent(obj);
                }

                public void onUpdate(V1ConfigMap oldObj, V1ConfigMap newObj) {
                    LOG.info((Object)("ConfigMap " + newObj.getMetadata().getName() + " was added."));
                    KubernetesClientEventBasedConfigMapChangeDetector.this.onEvent(newObj);
                }

                public void onDelete(V1ConfigMap obj, boolean deletedFinalStateUnknown) {
                    LOG.info((Object)("ConfigMap " + obj.getMetadata() + " was deleted."));
                    KubernetesClientEventBasedConfigMapChangeDetector.this.onEvent(obj);
                }
            });
            this.factory.startAllRegisteredInformers();
        }
    }

    @PreDestroy
    public void unwatch() {
        this.factory.stopAllRegisteredInformers();
    }

    private void onEvent(V1ConfigMap configMap) {
        boolean changed = this.changed(this.locateMapPropertySources((PropertySourceLocator)this.propertySourceLocator, (Environment)this.environment), this.findPropertySources(KubernetesClientConfigMapPropertySource.class));
        if (changed) {
            LOG.info((Object)"Configuration change detected, reloading properties.");
            this.reloadProperties();
        } else {
            LOG.warn((Object)"Configuration change was not detected.");
        }
    }
}

