/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gcp.storage.integration.inbound;

import com.google.cloud.storage.BlobInfo;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.cloud.gcp.storage.integration.GcsFileInfo;
import org.springframework.cloud.gcp.storage.integration.filters.GcsPersistentAcceptOnceFileListFilter;
import org.springframework.integration.file.filters.FileListFilter;
import org.springframework.integration.file.remote.AbstractFileInfo;
import org.springframework.integration.file.remote.AbstractRemoteFileStreamingMessageSource;
import org.springframework.integration.file.remote.RemoteFileTemplate;
import org.springframework.integration.metadata.ConcurrentMetadataStore;
import org.springframework.integration.metadata.SimpleMetadataStore;

public class GcsStreamingMessageSource
extends AbstractRemoteFileStreamingMessageSource<BlobInfo> {
    public GcsStreamingMessageSource(RemoteFileTemplate<BlobInfo> template) {
        super(template, null);
        this.doSetFilter((FileListFilter)new GcsPersistentAcceptOnceFileListFilter((ConcurrentMetadataStore)new SimpleMetadataStore(), "gcsStreamingMessageSource"));
    }

    public String getComponentType() {
        return "gcp:gcs-inbound-streaming-channel-adapter";
    }

    public void setRemoteFileSeparator(String remoteFileSeparator) {
        throw new UnsupportedOperationException("Google Cloud Storage doesn't support separators other than '/'.");
    }

    protected List<AbstractFileInfo<BlobInfo>> asFileInfoList(Collection<BlobInfo> collection) {
        return collection.stream().map(GcsFileInfo::new).collect(Collectors.toList());
    }

    protected boolean isDirectory(BlobInfo blobInfo) {
        return blobInfo.isDirectory();
    }
}

