/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gcp.security.firebase;

import com.nimbusds.jose.util.X509CertUtils;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTParser;
import com.nimbusds.jwt.SignedJWT;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.security.oauth2.core.OAuth2TokenValidator;
import org.springframework.security.oauth2.jose.jws.SignatureAlgorithm;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.jwt.JwtDecoder;
import org.springframework.security.oauth2.jwt.JwtException;
import org.springframework.security.oauth2.jwt.NimbusJwtDecoder;
import org.springframework.util.Assert;
import org.springframework.web.client.RestOperations;

public class FirebaseJwtTokenDecoder
implements JwtDecoder {
    private static final String DECODING_ERROR_MESSAGE_TEMPLATE = "An error occurred while attempting to decode the Jwt: %s";
    private final RestOperations restClient;
    private final String googlePublicKeysEndpoint;
    private final OAuth2TokenValidator<Jwt> tokenValidator;
    private final Logger logger = LoggerFactory.getLogger(FirebaseJwtTokenDecoder.class);
    private Pattern maxAgePattern = Pattern.compile("max-age=(\\d*)");
    private ReentrantLock keysLock = new ReentrantLock();
    private volatile Long expires = 0L;
    private Map<String, JwtDecoder> delegates = new ConcurrentHashMap<String, JwtDecoder>();

    public FirebaseJwtTokenDecoder(RestOperations restClient, String googlePublicKeysEndpoint, OAuth2TokenValidator<Jwt> tokenValidator) {
        this.restClient = restClient;
        this.googlePublicKeysEndpoint = googlePublicKeysEndpoint;
        this.tokenValidator = tokenValidator;
    }

    public Jwt decode(String token) throws JwtException {
        JwtDecoder decoder;
        SignedJWT jwt = this.parse(token);
        if (this.isExpired().booleanValue()) {
            try {
                this.keysLock.tryLock();
                this.refresh();
            }
            finally {
                this.keysLock.unlock();
            }
        }
        if ((decoder = this.delegates.get(jwt.getHeader().getKeyID())) == null) {
            throw new JwtException("No certificate found for key: " + jwt.getHeader().getKeyID());
        }
        return decoder.decode(token);
    }

    private void refresh() {
        if (!this.isExpired().booleanValue()) {
            return;
        }
        try {
            ResponseEntity response = this.restClient.exchange(this.googlePublicKeysEndpoint, HttpMethod.GET, null, (ParameterizedTypeReference)new ParameterizedTypeReference<Map<String, String>>(){}, new Object[0]);
            Long expiresAt = this.parseCacheControlHeaders(response.getHeaders());
            this.expires = expiresAt > -1L ? System.currentTimeMillis() + expiresAt * 1000L : 0L;
            if (!response.getStatusCode().is2xxSuccessful()) {
                throw new JwtException("Error retrieving public certificates from remote endpoint");
            }
            this.delegates.clear();
            for (String key : ((Map)response.getBody()).keySet()) {
                try {
                    NimbusJwtDecoder nimbusJwtDecoder = NimbusJwtDecoder.withPublicKey((RSAPublicKey)((RSAPublicKey)this.convertToX509Cert((String)((Map)response.getBody()).get(key)).getPublicKey())).signatureAlgorithm(SignatureAlgorithm.from((String)"RS256")).build();
                    nimbusJwtDecoder.setJwtValidator(this.tokenValidator);
                    this.delegates.put(key, (JwtDecoder)nimbusJwtDecoder);
                }
                catch (Exception ce) {
                    this.logger.error("Could not read certificate for key {}", (Object)key);
                }
            }
        }
        catch (Exception e) {
            throw new JwtException("Error fetching public keys", (Throwable)e);
        }
    }

    private SignedJWT parse(String token) {
        try {
            JWT jwt = JWTParser.parse((String)token);
            if (!(jwt instanceof SignedJWT)) {
                throw new JwtException("Unsupported algorithm of " + jwt.getHeader().getAlgorithm());
            }
            return (SignedJWT)jwt;
        }
        catch (Exception ex) {
            throw new JwtException(String.format(DECODING_ERROR_MESSAGE_TEMPLATE, ex.getMessage()), (Throwable)ex);
        }
    }

    private Boolean isExpired() {
        return System.currentTimeMillis() >= this.expires;
    }

    private X509Certificate convertToX509Cert(String certificateString) {
        X509Certificate certificate = X509CertUtils.parse((String)certificateString);
        Assert.notNull((Object)certificate, (String)"Could not parse certificate String");
        return certificate;
    }

    private Long parseCacheControlHeaders(HttpHeaders httpHeaders) {
        String[] headers;
        Long maxAge = -1L;
        List cacheControlHeaders = httpHeaders.get((Object)"Cache-Control");
        if (cacheControlHeaders == null || cacheControlHeaders.isEmpty()) {
            return maxAge;
        }
        for (String header : headers = ((String)cacheControlHeaders.get(0)).split(",")) {
            Matcher matcher = this.maxAgePattern.matcher(header.trim());
            if (!matcher.matches()) continue;
            return Long.valueOf(matcher.group(1));
        }
        return maxAge;
    }
}

