/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gcp.pubsub.support;

import com.google.api.core.ApiClock;
import com.google.api.gax.batching.FlowControlSettings;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.ExecutorProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.cloud.pubsub.v1.MessageReceiver;
import com.google.cloud.pubsub.v1.Subscriber;
import com.google.cloud.pubsub.v1.stub.GrpcSubscriberStub;
import com.google.cloud.pubsub.v1.stub.SubscriberStub;
import com.google.cloud.pubsub.v1.stub.SubscriberStubSettings;
import com.google.pubsub.v1.ProjectSubscriptionName;
import com.google.pubsub.v1.PullRequest;
import java.io.IOException;
import org.springframework.cloud.gcp.core.GcpProjectIdProvider;
import org.springframework.cloud.gcp.pubsub.support.PubSubSubscriptionUtils;
import org.springframework.cloud.gcp.pubsub.support.SubscriberFactory;
import org.springframework.util.Assert;
import org.threeten.bp.Duration;

public class DefaultSubscriberFactory
implements SubscriberFactory {
    private final String projectId;
    private ExecutorProvider executorProvider;
    private TransportChannelProvider channelProvider;
    private CredentialsProvider credentialsProvider;
    private HeaderProvider headerProvider;
    private ExecutorProvider systemExecutorProvider;
    private FlowControlSettings flowControlSettings;
    private Duration maxAckExtensionPeriod;
    private Integer parallelPullCount;
    private String pullEndpoint;
    private ApiClock apiClock;
    private RetrySettings subscriberStubRetrySettings;

    public DefaultSubscriberFactory(GcpProjectIdProvider projectIdProvider) {
        Assert.notNull((Object)projectIdProvider, (String)"The project ID provider can't be null.");
        this.projectId = projectIdProvider.getProjectId();
        Assert.hasText((String)this.projectId, (String)"The project ID can't be null or empty.");
    }

    @Override
    public String getProjectId() {
        return this.projectId;
    }

    public void setExecutorProvider(ExecutorProvider executorProvider) {
        this.executorProvider = executorProvider;
    }

    public void setChannelProvider(TransportChannelProvider channelProvider) {
        this.channelProvider = channelProvider;
    }

    public void setCredentialsProvider(CredentialsProvider credentialsProvider) {
        this.credentialsProvider = credentialsProvider;
    }

    public void setHeaderProvider(HeaderProvider headerProvider) {
        this.headerProvider = headerProvider;
    }

    public void setSystemExecutorProvider(ExecutorProvider systemExecutorProvider) {
        this.systemExecutorProvider = systemExecutorProvider;
    }

    public void setFlowControlSettings(FlowControlSettings flowControlSettings) {
        this.flowControlSettings = flowControlSettings;
    }

    public void setMaxAckExtensionPeriod(Duration maxAckExtensionPeriod) {
        this.maxAckExtensionPeriod = maxAckExtensionPeriod;
    }

    public void setParallelPullCount(Integer parallelPullCount) {
        this.parallelPullCount = parallelPullCount;
    }

    public void setPullEndpoint(String pullEndpoint) {
        this.pullEndpoint = pullEndpoint;
    }

    public void setApiClock(ApiClock apiClock) {
        this.apiClock = apiClock;
    }

    public void setSubscriberStubRetrySettings(RetrySettings subscriberStubRetrySettings) {
        this.subscriberStubRetrySettings = subscriberStubRetrySettings;
    }

    @Override
    public Subscriber createSubscriber(String subscriptionName, MessageReceiver receiver) {
        Subscriber.Builder subscriberBuilder = Subscriber.newBuilder((ProjectSubscriptionName)PubSubSubscriptionUtils.toProjectSubscriptionName(subscriptionName, this.projectId), (MessageReceiver)receiver);
        if (this.channelProvider != null) {
            subscriberBuilder.setChannelProvider(this.channelProvider);
        }
        if (this.executorProvider != null) {
            subscriberBuilder.setExecutorProvider(this.executorProvider);
        }
        if (this.credentialsProvider != null) {
            subscriberBuilder.setCredentialsProvider(this.credentialsProvider);
        }
        if (this.headerProvider != null) {
            subscriberBuilder.setHeaderProvider(this.headerProvider);
        }
        if (this.systemExecutorProvider != null) {
            subscriberBuilder.setSystemExecutorProvider(this.systemExecutorProvider);
        }
        if (this.flowControlSettings != null) {
            subscriberBuilder.setFlowControlSettings(this.flowControlSettings);
        }
        if (this.maxAckExtensionPeriod != null) {
            subscriberBuilder.setMaxAckExtensionPeriod(this.maxAckExtensionPeriod);
        }
        if (this.parallelPullCount != null) {
            subscriberBuilder.setParallelPullCount(this.parallelPullCount.intValue());
        }
        return subscriberBuilder.build();
    }

    @Override
    public PullRequest createPullRequest(String subscriptionName, Integer maxMessages, Boolean returnImmediately) {
        Assert.hasLength((String)subscriptionName, (String)"The subscription name must be provided.");
        PullRequest.Builder pullRequestBuilder = PullRequest.newBuilder().setSubscription(PubSubSubscriptionUtils.toProjectSubscriptionName(subscriptionName, this.projectId).toString());
        if (maxMessages != null) {
            pullRequestBuilder.setMaxMessages(maxMessages.intValue());
        }
        if (returnImmediately != null) {
            pullRequestBuilder.setReturnImmediately(returnImmediately.booleanValue());
        }
        return pullRequestBuilder.build();
    }

    @Override
    public SubscriberStub createSubscriberStub() {
        SubscriberStubSettings.Builder subscriberStubSettings = SubscriberStubSettings.newBuilder();
        if (this.credentialsProvider != null) {
            subscriberStubSettings.setCredentialsProvider(this.credentialsProvider);
        }
        if (this.pullEndpoint != null) {
            subscriberStubSettings.setEndpoint(this.pullEndpoint);
        }
        if (this.executorProvider != null) {
            subscriberStubSettings.setExecutorProvider(this.executorProvider);
        }
        if (this.headerProvider != null) {
            subscriberStubSettings.setHeaderProvider(this.headerProvider);
        }
        if (this.channelProvider != null) {
            subscriberStubSettings.setTransportChannelProvider(this.channelProvider);
        }
        if (this.apiClock != null) {
            subscriberStubSettings.setClock(this.apiClock);
        }
        if (this.subscriberStubRetrySettings != null) {
            subscriberStubSettings.pullSettings().setRetrySettings(this.subscriberStubRetrySettings);
        }
        try {
            return GrpcSubscriberStub.create((SubscriberStubSettings)subscriberStubSettings.build());
        }
        catch (IOException ex) {
            throw new RuntimeException("Error creating the SubscriberStub", ex);
        }
    }
}

