/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gcp.stream.binder.pubsub.provisioning;

import com.google.api.gax.rpc.AlreadyExistsException;
import com.google.pubsub.v1.Subscription;
import com.google.pubsub.v1.Topic;
import com.google.pubsub.v1.TopicName;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.gcp.pubsub.PubSubAdmin;
import org.springframework.cloud.gcp.stream.binder.pubsub.properties.PubSubConsumerProperties;
import org.springframework.cloud.gcp.stream.binder.pubsub.properties.PubSubProducerProperties;
import org.springframework.cloud.gcp.stream.binder.pubsub.provisioning.PubSubConsumerDestination;
import org.springframework.cloud.gcp.stream.binder.pubsub.provisioning.PubSubProducerDestination;
import org.springframework.cloud.stream.binder.ExtendedConsumerProperties;
import org.springframework.cloud.stream.binder.ExtendedProducerProperties;
import org.springframework.cloud.stream.provisioning.ConsumerDestination;
import org.springframework.cloud.stream.provisioning.ProducerDestination;
import org.springframework.cloud.stream.provisioning.ProvisioningException;
import org.springframework.cloud.stream.provisioning.ProvisioningProvider;
import org.springframework.util.StringUtils;

public class PubSubChannelProvisioner
implements ProvisioningProvider<ExtendedConsumerProperties<PubSubConsumerProperties>, ExtendedProducerProperties<PubSubProducerProperties>> {
    private static final Log LOGGER = LogFactory.getLog(PubSubChannelProvisioner.class);
    private final PubSubAdmin pubSubAdmin;
    private final Set<String> anonymousGroupSubscriptionNames = new HashSet<String>();

    public PubSubChannelProvisioner(PubSubAdmin pubSubAdmin) {
        this.pubSubAdmin = pubSubAdmin;
    }

    public ProducerDestination provisionProducerDestination(String topic, ExtendedProducerProperties<PubSubProducerProperties> properties) {
        this.ensureTopicExists(topic, ((PubSubProducerProperties)properties.getExtension()).isAutoCreateResources());
        return new PubSubProducerDestination(topic);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ConsumerDestination provisionConsumerDestination(String topicName, String group, ExtendedConsumerProperties<PubSubConsumerProperties> properties) {
        Subscription subscription;
        String subscriptionName;
        String topicShortName = TopicName.isParsableFrom((String)topicName) ? TopicName.parse((String)topicName).getTopic() : topicName;
        Optional<Topic> topic = this.ensureTopicExists(topicName, ((PubSubConsumerProperties)properties.getExtension()).isAutoCreateResources());
        if (StringUtils.hasText((String)group)) {
            subscriptionName = topicShortName + "." + group;
            subscription = this.pubSubAdmin.getSubscription(subscriptionName);
        } else {
            subscriptionName = "anonymous." + topicShortName + "." + UUID.randomUUID().toString();
            subscription = this.pubSubAdmin.createSubscription(subscriptionName, topicName);
            this.anonymousGroupSubscriptionNames.add(subscriptionName);
        }
        if (subscription == null) {
            if (!((PubSubConsumerProperties)properties.getExtension()).isAutoCreateResources()) throw new ProvisioningException("Non-existing '" + subscriptionName + "' subscription.");
            this.pubSubAdmin.createSubscription(subscriptionName, topicName);
            return new PubSubConsumerDestination(subscriptionName);
        } else {
            if (!topic.isPresent() || subscription.getTopic().equals(topic.get().getName())) return new PubSubConsumerDestination(subscriptionName);
            throw new ProvisioningException("Existing '" + subscriptionName + "' subscription is for a different topic '" + subscription.getTopic() + "'.");
        }
    }

    public void afterUnbindConsumer(ConsumerDestination destination) {
        if (this.anonymousGroupSubscriptionNames.remove(destination.getName())) {
            try {
                this.pubSubAdmin.deleteSubscription(destination.getName());
            }
            catch (Exception ex) {
                LOGGER.warn((Object)("Failed to delete auto-created anonymous subscription '" + destination.getName() + "'."));
            }
        }
    }

    private Optional<Topic> ensureTopicExists(String topicName, boolean autoCreate) {
        Topic topic = this.pubSubAdmin.getTopic(topicName);
        if (topic == null) {
            if (autoCreate) {
                try {
                    topic = this.pubSubAdmin.createTopic(topicName);
                }
                catch (AlreadyExistsException alreadyExistsException) {
                    LOGGER.info((Object)("Failed to auto-create topic '" + topicName + "' because it already exists."));
                }
            } else {
                throw new ProvisioningException("Non-existing '" + topicName + "' topic.");
            }
        }
        return Optional.ofNullable(topic);
    }
}

