/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gcp.stream.binder.pubsub;

import org.springframework.beans.factory.BeanFactory;
import org.springframework.cloud.gcp.pubsub.core.PubSubTemplate;
import org.springframework.cloud.gcp.pubsub.core.publisher.PubSubPublisherOperations;
import org.springframework.cloud.gcp.pubsub.core.subscriber.PubSubSubscriberOperations;
import org.springframework.cloud.gcp.pubsub.integration.inbound.PubSubInboundChannelAdapter;
import org.springframework.cloud.gcp.pubsub.integration.inbound.PubSubMessageSource;
import org.springframework.cloud.gcp.pubsub.integration.outbound.PubSubMessageHandler;
import org.springframework.cloud.gcp.stream.binder.pubsub.properties.PubSubConsumerProperties;
import org.springframework.cloud.gcp.stream.binder.pubsub.properties.PubSubExtendedBindingProperties;
import org.springframework.cloud.gcp.stream.binder.pubsub.properties.PubSubProducerProperties;
import org.springframework.cloud.gcp.stream.binder.pubsub.provisioning.PubSubChannelProvisioner;
import org.springframework.cloud.stream.binder.AbstractMessageChannelBinder;
import org.springframework.cloud.stream.binder.BinderSpecificPropertiesProvider;
import org.springframework.cloud.stream.binder.ConsumerProperties;
import org.springframework.cloud.stream.binder.ExtendedConsumerProperties;
import org.springframework.cloud.stream.binder.ExtendedProducerProperties;
import org.springframework.cloud.stream.binder.ExtendedPropertiesBinder;
import org.springframework.cloud.stream.provisioning.ConsumerDestination;
import org.springframework.cloud.stream.provisioning.ProducerDestination;
import org.springframework.cloud.stream.provisioning.ProvisioningProvider;
import org.springframework.integration.core.MessageProducer;
import org.springframework.integration.core.MessageSource;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageHandler;

public class PubSubMessageChannelBinder
extends AbstractMessageChannelBinder<ExtendedConsumerProperties<PubSubConsumerProperties>, ExtendedProducerProperties<PubSubProducerProperties>, PubSubChannelProvisioner>
implements ExtendedPropertiesBinder<MessageChannel, PubSubConsumerProperties, PubSubProducerProperties> {
    private final PubSubTemplate pubSubTemplate;
    private final PubSubExtendedBindingProperties pubSubExtendedBindingProperties;
    private final PubSubChannelProvisioner pubSubChannelProvisioner;

    public PubSubMessageChannelBinder(String[] headersToEmbed, PubSubChannelProvisioner provisioningProvider, PubSubTemplate pubSubTemplate, PubSubExtendedBindingProperties pubSubExtendedBindingProperties) {
        super(headersToEmbed, (ProvisioningProvider)provisioningProvider);
        this.pubSubTemplate = pubSubTemplate;
        this.pubSubExtendedBindingProperties = pubSubExtendedBindingProperties;
        this.pubSubChannelProvisioner = provisioningProvider;
    }

    protected MessageHandler createProducerMessageHandler(ProducerDestination destination, ExtendedProducerProperties<PubSubProducerProperties> producerProperties, MessageChannel errorChannel) {
        PubSubMessageHandler messageHandler = new PubSubMessageHandler((PubSubPublisherOperations)this.pubSubTemplate, destination.getName());
        messageHandler.setBeanFactory((BeanFactory)this.getBeanFactory());
        return messageHandler;
    }

    protected MessageProducer createConsumerEndpoint(ConsumerDestination destination, String group, ExtendedConsumerProperties<PubSubConsumerProperties> properties) {
        PubSubInboundChannelAdapter adapter = new PubSubInboundChannelAdapter((PubSubSubscriberOperations)this.pubSubTemplate, destination.getName());
        AbstractMessageChannelBinder.ErrorInfrastructure errorInfrastructure = this.registerErrorInfrastructure(destination, group, (ConsumerProperties)properties);
        adapter.setErrorChannel((MessageChannel)errorInfrastructure.getErrorChannel());
        adapter.setAckMode(((PubSubConsumerProperties)properties.getExtension()).getAckMode());
        return adapter;
    }

    protected String errorsBaseName(ConsumerDestination destination, String group, ExtendedConsumerProperties<PubSubConsumerProperties> properties) {
        return destination.getName() + ".errors";
    }

    public PubSubConsumerProperties getExtendedConsumerProperties(String channelName) {
        return (PubSubConsumerProperties)this.pubSubExtendedBindingProperties.getExtendedConsumerProperties(channelName);
    }

    public PubSubProducerProperties getExtendedProducerProperties(String channelName) {
        return (PubSubProducerProperties)this.pubSubExtendedBindingProperties.getExtendedProducerProperties(channelName);
    }

    public String getDefaultsPrefix() {
        return this.pubSubExtendedBindingProperties.getDefaultsPrefix();
    }

    public Class<? extends BinderSpecificPropertiesProvider> getExtendedPropertiesEntryClass() {
        return this.pubSubExtendedBindingProperties.getExtendedPropertiesEntryClass();
    }

    protected void afterUnbindConsumer(ConsumerDestination destination, String group, ExtendedConsumerProperties<PubSubConsumerProperties> consumerProperties) {
        super.afterUnbindConsumer(destination, group, consumerProperties);
        this.pubSubChannelProvisioner.afterUnbindConsumer(destination);
    }

    protected AbstractMessageChannelBinder.PolledConsumerResources createPolledConsumerResources(String name, String group, ConsumerDestination destination, ExtendedConsumerProperties<PubSubConsumerProperties> consumerProperties) {
        return new AbstractMessageChannelBinder.PolledConsumerResources((MessageSource)new PubSubMessageSource((PubSubSubscriberOperations)this.pubSubTemplate, destination.getName()), this.registerErrorInfrastructure(destination, group, (ConsumerProperties)consumerProperties, true));
    }
}

