/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gcp.stream.binder.pubsub.provisioning;

import org.springframework.cloud.gcp.pubsub.PubSubAdmin;
import org.springframework.cloud.gcp.stream.binder.pubsub.properties.PubSubConsumerProperties;
import org.springframework.cloud.gcp.stream.binder.pubsub.properties.PubSubProducerProperties;
import org.springframework.cloud.gcp.stream.binder.pubsub.provisioning.PubSubConsumerDestination;
import org.springframework.cloud.gcp.stream.binder.pubsub.provisioning.PubSubProducerDestination;
import org.springframework.cloud.stream.binder.ExtendedConsumerProperties;
import org.springframework.cloud.stream.binder.ExtendedProducerProperties;
import org.springframework.cloud.stream.provisioning.ConsumerDestination;
import org.springframework.cloud.stream.provisioning.ProducerDestination;
import org.springframework.cloud.stream.provisioning.ProvisioningException;
import org.springframework.cloud.stream.provisioning.ProvisioningProvider;

public class PubSubChannelProvisioner
implements ProvisioningProvider<ExtendedConsumerProperties<PubSubConsumerProperties>, ExtendedProducerProperties<PubSubProducerProperties>> {
    private final PubSubAdmin pubSubAdmin;

    public PubSubChannelProvisioner(PubSubAdmin pubSubAdmin) {
        this.pubSubAdmin = pubSubAdmin;
    }

    public ProducerDestination provisionProducerDestination(String name, ExtendedProducerProperties<PubSubProducerProperties> properties) throws ProvisioningException {
        if (this.pubSubAdmin.getTopic(name) == null) {
            this.pubSubAdmin.createTopic(name);
        }
        return new PubSubProducerDestination(name);
    }

    public ConsumerDestination provisionConsumerDestination(String name, String group, ExtendedConsumerProperties<PubSubConsumerProperties> properties) throws ProvisioningException {
        String subscription;
        String string = subscription = group == null ? name : name + '.' + group;
        if (this.pubSubAdmin.getSubscription(subscription) == null) {
            if (((PubSubConsumerProperties)properties.getExtension()).isAutoCreateResources()) {
                if (this.pubSubAdmin.getTopic(name) == null) {
                    this.pubSubAdmin.createTopic(name);
                }
                this.pubSubAdmin.createSubscription(subscription, name);
            } else {
                throw new ProvisioningException("Unexisting '" + subscription + "' subscription.");
            }
        }
        return new PubSubConsumerDestination(subscription);
    }
}

