/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gcp.data.spanner.core;

import com.google.cloud.Timestamp;
import com.google.cloud.spanner.TimestampBound;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class AbstractSpannerRequestOptions<A>
implements Serializable {
    protected transient List<A> requestOptions = new ArrayList<A>();
    protected Class<A> requestOptionType;
    private TimestampBound timestampBound;
    private Set<String> includeProperties;
    private boolean allowPartialRead;

    public Set<String> getIncludeProperties() {
        return this.includeProperties;
    }

    public AbstractSpannerRequestOptions setIncludeProperties(Set<String> includeProperties) {
        this.includeProperties = includeProperties;
        return this;
    }

    public TimestampBound getTimestampBound() {
        return this.timestampBound;
    }

    public AbstractSpannerRequestOptions setTimestampBound(TimestampBound timestampBound) {
        this.timestampBound = timestampBound;
        return this;
    }

    public Timestamp getTimestamp() {
        return this.timestampBound.getMode() == TimestampBound.Mode.READ_TIMESTAMP ? this.timestampBound.getReadTimestamp() : this.timestampBound.getMinReadTimestamp();
    }

    public AbstractSpannerRequestOptions setTimestamp(Timestamp timestamp) {
        this.timestampBound = TimestampBound.ofReadTimestamp((Timestamp)timestamp);
        return this;
    }

    public A[] getOptions() {
        return this.requestOptions.toArray((Object[])Array.newInstance(this.requestOptionType, 0));
    }

    public boolean isAllowPartialRead() {
        return this.allowPartialRead;
    }

    public AbstractSpannerRequestOptions setAllowPartialRead(boolean allowPartialRead) {
        this.allowPartialRead = allowPartialRead;
        return this;
    }
}

