/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gcp.data.spanner.repository.query;

import java.lang.reflect.Method;
import org.springframework.cloud.gcp.data.spanner.core.SpannerTemplate;
import org.springframework.cloud.gcp.data.spanner.core.mapping.SpannerMappingContext;
import org.springframework.cloud.gcp.data.spanner.core.mapping.SpannerPersistentEntity;
import org.springframework.cloud.gcp.data.spanner.core.mapping.SpannerPersistentProperty;
import org.springframework.cloud.gcp.data.spanner.repository.query.PartTreeSpannerQuery;
import org.springframework.cloud.gcp.data.spanner.repository.query.Query;
import org.springframework.cloud.gcp.data.spanner.repository.query.SpannerQueryMethod;
import org.springframework.cloud.gcp.data.spanner.repository.query.SqlSpannerQuery;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.repository.core.NamedQueries;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.query.QueryLookupStrategy;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.repository.query.QueryMethodEvaluationContextProvider;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.util.Assert;

public class SpannerQueryLookupStrategy
implements QueryLookupStrategy {
    private final SpannerTemplate spannerTemplate;
    private final SpannerMappingContext spannerMappingContext;
    private QueryMethodEvaluationContextProvider evaluationContextProvider;
    private SpelExpressionParser expressionParser;

    public SpannerQueryLookupStrategy(SpannerMappingContext spannerMappingContext, SpannerTemplate spannerTemplate, QueryMethodEvaluationContextProvider evaluationContextProvider, SpelExpressionParser expressionParser) {
        Assert.notNull((Object)((Object)spannerMappingContext), (String)"A valid SpannerMappingContext is required.");
        Assert.notNull((Object)spannerTemplate, (String)"A valid SpannerTemplate is required.");
        Assert.notNull((Object)evaluationContextProvider, (String)"A valid EvaluationContextProvider is required.");
        Assert.notNull((Object)expressionParser, (String)"A valid SpelExpressionParser is required.");
        this.spannerMappingContext = spannerMappingContext;
        this.evaluationContextProvider = evaluationContextProvider;
        this.spannerTemplate = spannerTemplate;
        this.expressionParser = expressionParser;
    }

    Class<?> getEntityType(QueryMethod queryMethod) {
        return queryMethod.getResultProcessor().getReturnedType().getDomainType();
    }

    SpannerQueryMethod createQueryMethod(Method method, RepositoryMetadata metadata, ProjectionFactory factory) {
        return new SpannerQueryMethod(method, metadata, factory, (MappingContext<? extends SpannerPersistentEntity<?>, SpannerPersistentProperty>)this.spannerMappingContext);
    }

    public RepositoryQuery resolveQuery(Method method, RepositoryMetadata metadata, ProjectionFactory factory, NamedQueries namedQueries) {
        boolean isDml;
        SpannerQueryMethod queryMethod = this.createQueryMethod(method, metadata, factory);
        Class<?> entityType = this.getEntityType(queryMethod);
        boolean bl = isDml = queryMethod.getQueryAnnotation() != null && queryMethod.getQueryAnnotation().dmlStatement();
        if (queryMethod.hasAnnotatedQuery()) {
            Query query = queryMethod.getQueryAnnotation();
            return this.createSqlSpannerQuery(entityType, queryMethod, query.value(), isDml);
        }
        if (namedQueries.hasQuery(queryMethod.getNamedQueryName())) {
            String sql = namedQueries.getQuery(queryMethod.getNamedQueryName());
            return this.createSqlSpannerQuery(entityType, queryMethod, sql, isDml);
        }
        return this.createPartTreeSpannerQuery(entityType, queryMethod);
    }

    <T> SqlSpannerQuery<T> createSqlSpannerQuery(Class<T> entityType, SpannerQueryMethod queryMethod, String sql, boolean isDml) {
        return new SqlSpannerQuery<T>(entityType, queryMethod, this.spannerTemplate, sql, this.evaluationContextProvider, this.expressionParser, this.spannerMappingContext, isDml);
    }

    <T> PartTreeSpannerQuery<T> createPartTreeSpannerQuery(Class<T> entityType, SpannerQueryMethod queryMethod) {
        return new PartTreeSpannerQuery<T>(entityType, queryMethod, this.spannerTemplate, this.spannerMappingContext);
    }
}

