/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gcp.data.spanner.core;

import com.google.cloud.Timestamp;
import com.google.cloud.spanner.Options;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.springframework.util.Assert;

public class SpannerQueryOptions {
    private List<Options.QueryOption> queryOptions = new ArrayList<Options.QueryOption>();
    private Timestamp timestamp;
    private Set<String> includeProperties;
    private boolean allowPartialRead;

    public SpannerQueryOptions addQueryOption(Options.QueryOption queryOption) {
        Assert.notNull((Object)queryOption, (String)"Valid query option is required!");
        this.queryOptions.add(queryOption);
        return this;
    }

    public Set<String> getIncludeProperties() {
        return this.includeProperties;
    }

    public SpannerQueryOptions setIncludeProperties(Set<String> includeProperties) {
        this.includeProperties = includeProperties;
        return this;
    }

    public Timestamp getTimestamp() {
        return this.timestamp;
    }

    public SpannerQueryOptions setTimestamp(Timestamp timestamp) {
        Assert.notNull((Object)timestamp, (String)"A valid timestamp is required!");
        this.timestamp = timestamp;
        return this;
    }

    public Options.QueryOption[] getQueryOptions() {
        return this.queryOptions.toArray(new Options.QueryOption[this.queryOptions.size()]);
    }

    public boolean isAllowPartialRead() {
        return this.allowPartialRead;
    }

    public SpannerQueryOptions setAllowPartialRead(boolean allowPartialRead) {
        this.allowPartialRead = allowPartialRead;
        return this;
    }
}

