/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gcp.data.spanner.core;

import com.google.cloud.Timestamp;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.Mutation;
import com.google.cloud.spanner.ReadContext;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.TransactionContext;
import java.util.Collection;
import java.util.function.Function;
import org.springframework.cloud.gcp.data.spanner.core.SpannerMutationFactory;
import org.springframework.cloud.gcp.data.spanner.core.SpannerReadOptions;
import org.springframework.cloud.gcp.data.spanner.core.SpannerTemplate;
import org.springframework.cloud.gcp.data.spanner.core.admin.SpannerSchemaUtils;
import org.springframework.cloud.gcp.data.spanner.core.convert.SpannerEntityProcessor;
import org.springframework.cloud.gcp.data.spanner.core.mapping.SpannerDataException;
import org.springframework.cloud.gcp.data.spanner.core.mapping.SpannerMappingContext;

class ReadWriteTransactionSpannerTemplate
extends SpannerTemplate {
    private TransactionContext transactionContext;

    ReadWriteTransactionSpannerTemplate(DatabaseClient databaseClient, SpannerMappingContext mappingContext, SpannerEntityProcessor spannerEntityProcessor, SpannerMutationFactory spannerMutationFactory, SpannerSchemaUtils spannerSchemaUtils, TransactionContext transactionContext) {
        super(databaseClient, mappingContext, spannerEntityProcessor, spannerMutationFactory, spannerSchemaUtils);
        this.transactionContext = transactionContext;
    }

    @Override
    protected void applyMutations(Collection<Mutation> mutations) {
        this.transactionContext.buffer(mutations);
    }

    @Override
    protected ReadContext getReadContext() {
        return this.transactionContext;
    }

    @Override
    public long executeDmlStatement(Statement statement) {
        return this.transactionContext.executeUpdate(statement);
    }

    @Override
    protected ReadContext getReadContext(Timestamp timestamp) {
        throw new SpannerDataException("Getting stale snapshot read contexts is not supported in read-write transaction templates.");
    }

    @Override
    public <T> T performReadWriteTransaction(Function<SpannerTemplate, T> operations) {
        throw new SpannerDataException("A read-write transaction is already under execution. Opening sub-transactions is not supported!");
    }

    @Override
    public <T> T performReadOnlyTransaction(Function<SpannerTemplate, T> operations, SpannerReadOptions readOptions) {
        throw new SpannerDataException("A read-write transaction is already under execution. Opening sub-transactions is not supported!");
    }
}

