/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gcp.data.spanner.repository.query;

import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.Struct;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.cloud.gcp.data.spanner.core.SpannerPageableQueryOptions;
import org.springframework.cloud.gcp.data.spanner.core.SpannerQueryOptions;
import org.springframework.cloud.gcp.data.spanner.core.SpannerTemplate;
import org.springframework.cloud.gcp.data.spanner.core.convert.StructAccessor;
import org.springframework.cloud.gcp.data.spanner.core.mapping.SpannerDataException;
import org.springframework.cloud.gcp.data.spanner.core.mapping.SpannerMappingContext;
import org.springframework.cloud.gcp.data.spanner.core.mapping.SpannerPersistentEntity;
import org.springframework.cloud.gcp.data.spanner.repository.query.AbstractSpannerQuery;
import org.springframework.cloud.gcp.data.spanner.repository.query.SpannerQueryMethod;
import org.springframework.cloud.gcp.data.spanner.repository.query.SpannerStatementQueryExecutor;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.repository.query.Parameter;
import org.springframework.data.repository.query.Parameters;
import org.springframework.data.repository.query.QueryMethodEvaluationContextProvider;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ParserContext;
import org.springframework.expression.common.CompositeStringExpression;
import org.springframework.expression.common.LiteralExpression;
import org.springframework.expression.spel.standard.SpelExpression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.util.StringUtils;

public class SqlSpannerQuery<T>
extends AbstractSpannerQuery<T> {
    private static String ENTITY_CLASS_NAME_BOOKEND = ":";
    private final String sql;
    private final boolean isDml;
    private final Function<Object, Struct> paramStructConvertFunc = param -> {
        Struct.Builder builder = Struct.newBuilder();
        this.spannerTemplate.getSpannerEntityProcessor().write(param, arg_0 -> ((Struct.Builder)builder).set(arg_0));
        return builder.build();
    };
    private QueryMethodEvaluationContextProvider evaluationContextProvider;
    private SpelExpressionParser expressionParser;

    SqlSpannerQuery(Class<T> type, SpannerQueryMethod queryMethod, SpannerTemplate spannerTemplate, String sql, QueryMethodEvaluationContextProvider evaluationContextProvider, SpelExpressionParser expressionParser, SpannerMappingContext spannerMappingContext, boolean isDml) {
        super(type, queryMethod, spannerTemplate, spannerMappingContext);
        this.evaluationContextProvider = evaluationContextProvider;
        this.expressionParser = expressionParser;
        this.sql = StringUtils.trimTrailingCharacter((String)sql.trim(), (char)';');
        this.isDml = isDml;
    }

    private boolean isPageableOrSort(Class type) {
        return Pageable.class.isAssignableFrom(type) || Sort.class.isAssignableFrom(type);
    }

    private List<String> getParamTags() {
        ArrayList<String> tags = new ArrayList<String>();
        HashSet<String> seen = new HashSet<String>();
        Parameters parameters = this.getQueryMethod().getParameters();
        for (int i = 0; i < parameters.getNumberOfParameters(); ++i) {
            Parameter param = parameters.getParameter(i);
            if (this.isPageableOrSort(param.getType())) continue;
            Optional paramName = param.getName();
            if (!paramName.isPresent()) {
                throw new SpannerDataException("Query method has a parameter without a valid name: " + this.getQueryMethod().getName());
            }
            String name = (String)paramName.get();
            if (seen.contains(name)) {
                throw new SpannerDataException("More than one param has the same name: " + name);
            }
            seen.add(name);
            tags.add(name);
        }
        return tags;
    }

    private String resolveEntityClassNames(String sql) {
        Pattern pattern = Pattern.compile("\\" + ENTITY_CLASS_NAME_BOOKEND + "\\S+\\" + ENTITY_CLASS_NAME_BOOKEND + "");
        Matcher matcher = pattern.matcher(sql);
        String result = sql;
        while (matcher.find()) {
            String matched = matcher.group();
            String className = matched.substring(1, matched.length() - 1);
            try {
                Class<?> entityClass = Class.forName(className);
                SpannerPersistentEntity spannerPersistentEntity = (SpannerPersistentEntity)this.spannerMappingContext.getPersistentEntity(entityClass);
                if (spannerPersistentEntity == null) {
                    throw new SpannerDataException("The class used in the SQL statement is not a Cloud Spanner persistent entity: " + className);
                }
                result = result.replace(matched, spannerPersistentEntity.tableName());
            }
            catch (ClassNotFoundException ex) {
                throw new SpannerDataException("The class name does not refer to an available entity type: " + className);
            }
        }
        return result;
    }

    private void resolveSpELTags(QueryTagValue queryTagValue) {
        Expression[] expressions = this.detectExpressions(queryTagValue.sql);
        StringBuilder sb = new StringBuilder();
        HashMap<Object, String> valueToTag = new HashMap<Object, String>();
        int tagNum = 0;
        EvaluationContext evaluationContext = this.evaluationContextProvider.getEvaluationContext(this.queryMethod.getParameters(), queryTagValue.rawParams);
        for (Expression expression : expressions) {
            if (expression instanceof LiteralExpression) {
                sb.append((String)expression.getValue(String.class));
                continue;
            }
            if (expression instanceof SpelExpression) {
                String newTag;
                Object value = expression.getValue(evaluationContext);
                if (valueToTag.containsKey(value)) {
                    sb.append("@").append((String)valueToTag.get(value));
                    continue;
                }
                while (queryTagValue.initialTags.contains(newTag = "SpELtag" + ++tagNum)) {
                }
                valueToTag.put(value, newTag);
                queryTagValue.params.add(value);
                queryTagValue.tags.add(newTag);
                sb.append("@").append(newTag);
                continue;
            }
            throw new SpannerDataException("Unexpected expression type. SQL queries are expected to be concatenation of Literal and SpEL expressions.");
        }
        queryTagValue.sql = sb.toString();
    }

    @Override
    public List executeRawResult(Object[] parameters) {
        ArrayList<Object> params = new ArrayList<Object>();
        Pageable pageable = null;
        Sort sort = null;
        for (Object param : parameters) {
            Class<?> paramClass = param.getClass();
            if (this.isPageableOrSort(paramClass)) {
                if (pageable != null || sort != null) {
                    throw new SpannerDataException("Only a single Pageable or Sort param is allowed.");
                }
                if (Pageable.class.isAssignableFrom(paramClass)) {
                    pageable = (Pageable)param;
                    continue;
                }
                sort = (Sort)param;
                continue;
            }
            params.add(param);
        }
        QueryTagValue queryTagValue = new QueryTagValue(this.getParamTags(), parameters, params.toArray(), this.resolveEntityClassNames(this.sql));
        this.resolveSpELTags(queryTagValue);
        return this.isDml ? Collections.singletonList(this.spannerTemplate.executeDmlStatement(this.buildStatementFromQueryAndTags(queryTagValue))) : this.executeReadSql(pageable, sort, queryTagValue);
    }

    private List executeReadSql(Pageable pageable, Sort sort, QueryTagValue queryTagValue) {
        SpannerPageableQueryOptions spannerQueryOptions = new SpannerPageableQueryOptions().setAllowPartialRead(true);
        if (pageable == null) {
            if (sort != null) {
                spannerQueryOptions.setSort(sort);
            }
        } else {
            spannerQueryOptions.setSort(pageable.getSort()).setOffset(pageable.getOffset()).setLimit(pageable.getPageSize());
        }
        queryTagValue.sql = SpannerStatementQueryExecutor.applySortingPagingQueryOptions(this.entityType, spannerQueryOptions, this.resolveEntityClassNames(queryTagValue.sql), this.spannerMappingContext);
        Class simpleItemType = this.getReturnedSimpleConvertableItemType();
        Statement statement = this.buildStatementFromQueryAndTags(queryTagValue);
        return simpleItemType != null ? this.spannerTemplate.query(struct -> new StructAccessor((Struct)struct).getSingleValue(0), statement, (SpannerQueryOptions)spannerQueryOptions) : this.spannerTemplate.query(this.entityType, statement, (SpannerQueryOptions)spannerQueryOptions);
    }

    private Statement buildStatementFromQueryAndTags(QueryTagValue queryTagValue) {
        return SpannerStatementQueryExecutor.buildStatementFromSqlWithArgs(queryTagValue.sql, queryTagValue.tags, this.paramStructConvertFunc, null, queryTagValue.params.toArray());
    }

    private Expression[] detectExpressions(String sql) {
        Expression expression = this.expressionParser.parseExpression(sql, ParserContext.TEMPLATE_EXPRESSION);
        if (expression instanceof LiteralExpression) {
            return new Expression[]{expression};
        }
        if (expression instanceof CompositeStringExpression) {
            return ((CompositeStringExpression)expression).getExpressions();
        }
        throw new SpannerDataException("Unexpected expression type. Query can either contain no SpEL expressions or have SpEL expressions in the SQL.");
    }

    private static class QueryTagValue {
        List<String> tags;
        final Set<String> initialTags;
        List<Object> params;
        final Object[] intialParams;
        final Object[] rawParams;
        String sql;

        QueryTagValue(List<String> tags, Object[] rawParams, Object[] params, String sql) {
            this.tags = tags;
            this.intialParams = params;
            this.sql = sql;
            this.initialTags = new HashSet<String>(tags);
            this.params = new ArrayList<Object>(Arrays.asList(params));
            this.rawParams = rawParams;
        }
    }
}

