/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gcp.data.firestore.repository.support;

import org.springframework.cloud.gcp.data.firestore.FirestoreTemplate;
import org.springframework.cloud.gcp.data.firestore.mapping.FirestoreMappingContext;
import org.springframework.cloud.gcp.data.firestore.repository.support.ReactiveFirestoreRepositoryFactory;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.repository.Repository;
import org.springframework.data.repository.core.support.RepositoryFactoryBeanSupport;
import org.springframework.data.repository.core.support.RepositoryFactorySupport;

public class FirestoreRepositoryFactoryBean<T extends Repository<S, ID>, S, ID>
extends RepositoryFactoryBeanSupport<T, S, ID> {
    private FirestoreTemplate firestoreTemplate;
    private FirestoreMappingContext firestoreMappingContext;

    FirestoreRepositoryFactoryBean(Class<T> repositoryInterface) {
        super(repositoryInterface);
    }

    public void setFirestoreTemplate(FirestoreTemplate firestoreTemplate) {
        this.firestoreTemplate = firestoreTemplate;
    }

    public void setFirestoreMappingContext(FirestoreMappingContext mappingContext) {
        super.setMappingContext((MappingContext)mappingContext);
        this.firestoreMappingContext = mappingContext;
    }

    protected RepositoryFactorySupport createRepositoryFactory() {
        return new ReactiveFirestoreRepositoryFactory(this.firestoreTemplate, this.firestoreMappingContext);
    }
}

