/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gcp.data.firestore.mapping;

import com.google.cloud.Timestamp;
import com.google.cloud.firestore.DocumentSnapshot;
import com.google.cloud.firestore.FirestoreOptions;
import com.google.cloud.firestore.Internal;
import com.google.firestore.v1.Document;
import com.google.firestore.v1.Value;
import java.util.Map;
import org.springframework.cloud.gcp.core.util.MapBuilder;
import org.springframework.cloud.gcp.data.firestore.mapping.FirestoreClassMapper;

public final class FirestoreDefaultClassMapper
implements FirestoreClassMapper {
    private static final Internal INTERNAL = new Internal(((FirestoreOptions.Builder)FirestoreOptions.newBuilder().setProjectId("dummy-project-id")).build(), null);
    private static final String VALUE_FIELD_NAME = "value";
    private static final String NOT_USED_PATH = "/not/used/path";

    @Override
    public <T> Value toFirestoreValue(T sourceValue) {
        DocumentSnapshot documentSnapshot = INTERNAL.snapshotFromMap(NOT_USED_PATH, new MapBuilder().put((Object)VALUE_FIELD_NAME, sourceValue).build());
        return (Value)INTERNAL.protoFromSnapshot(documentSnapshot).get(VALUE_FIELD_NAME);
    }

    @Override
    public <T> Document entityToDocument(T entity, String documentResourceName) {
        DocumentSnapshot documentSnapshot = INTERNAL.snapshotFromObject(NOT_USED_PATH, entity);
        Map valuesMap = INTERNAL.protoFromSnapshot(documentSnapshot);
        return Document.newBuilder().putAllFields(valuesMap).setName(documentResourceName).build();
    }

    @Override
    public <T> T documentToEntity(Document document, Class<T> clazz) {
        DocumentSnapshot documentSnapshot = INTERNAL.snapshotFromProto(Timestamp.now(), document);
        return (T)documentSnapshot.toObject(clazz);
    }
}

