/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gcp.data.firestore;

import com.google.firestore.v1.Document;
import com.google.firestore.v1.DocumentMask;
import com.google.firestore.v1.FirestoreGrpc;
import com.google.firestore.v1.GetDocumentRequest;
import com.google.firestore.v1.Precondition;
import com.google.firestore.v1.RunQueryRequest;
import com.google.firestore.v1.RunQueryResponse;
import com.google.firestore.v1.StructuredQuery;
import com.google.firestore.v1.Write;
import com.google.firestore.v1.WriteRequest;
import com.google.firestore.v1.WriteResponse;
import io.grpc.stub.StreamObserver;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import org.reactivestreams.Publisher;
import org.springframework.cloud.gcp.data.firestore.AutoId;
import org.springframework.cloud.gcp.data.firestore.FirestoreDataException;
import org.springframework.cloud.gcp.data.firestore.FirestoreReactiveOperations;
import org.springframework.cloud.gcp.data.firestore.mapping.FirestoreClassMapper;
import org.springframework.cloud.gcp.data.firestore.mapping.FirestoreMappingContext;
import org.springframework.cloud.gcp.data.firestore.mapping.FirestorePersistentEntity;
import org.springframework.cloud.gcp.data.firestore.mapping.FirestorePersistentProperty;
import org.springframework.cloud.gcp.data.firestore.transaction.ReactiveFirestoreResourceHolder;
import org.springframework.cloud.gcp.data.firestore.util.ObservableReactiveUtil;
import org.springframework.cloud.gcp.data.firestore.util.Util;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.transaction.reactive.TransactionContext;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.context.Context;

public class FirestoreTemplate
implements FirestoreReactiveOperations {
    private FirestoreClassMapper classMapper;
    private static final int FIRESTORE_WRITE_MAX_SIZE = 500;
    private static final String NAME_FIELD = "__name__";
    private static final StructuredQuery.Projection ID_PROJECTION = StructuredQuery.Projection.newBuilder().addFields(StructuredQuery.FieldReference.newBuilder().setFieldPath("__name__").build()).build();
    private static final DocumentMask NAME_ONLY_MASK = DocumentMask.newBuilder().addFieldPaths("__name__").build();
    private static final String NOT_FOUND_DOCUMENT_MESSAGE = "NOT_FOUND: Document";
    private final FirestoreGrpc.FirestoreStub firestore;
    private final String parent;
    private final String databasePath;
    private final FirestoreMappingContext mappingContext;
    private Duration writeBufferTimeout = Duration.ofMillis(500L);
    private int writeBufferSize = 500;
    private boolean usingStreamTokens = true;

    public FirestoreTemplate(FirestoreGrpc.FirestoreStub firestore, String parent, FirestoreClassMapper classMapper, FirestoreMappingContext mappingContext) {
        this.firestore = firestore;
        this.parent = parent;
        this.databasePath = Util.extractDatabasePath(parent);
        this.classMapper = classMapper;
        this.mappingContext = mappingContext;
    }

    @Override
    public <T> FirestoreReactiveOperations withParent(T parent) {
        FirestoreTemplate firestoreTemplate = new FirestoreTemplate(this.firestore, this.buildResourceName(parent), this.classMapper, this.mappingContext);
        firestoreTemplate.setUsingStreamTokens(this.usingStreamTokens);
        firestoreTemplate.setWriteBufferSize(this.writeBufferSize);
        firestoreTemplate.setWriteBufferTimeout(this.writeBufferTimeout);
        return firestoreTemplate;
    }

    public void setWriteBufferTimeout(Duration bufferTimeout) {
        this.writeBufferTimeout = bufferTimeout;
    }

    public Duration getWriteBufferTimeout() {
        return this.writeBufferTimeout;
    }

    public void setWriteBufferSize(int bufferWriteSize) {
        Assert.isTrue((bufferWriteSize <= 500 ? 1 : 0) != 0, (String)"The FirestoreTemplate buffer write size must be less than 500");
        this.writeBufferSize = bufferWriteSize;
    }

    public int getWriteBufferSize() {
        return this.writeBufferSize;
    }

    public void setUsingStreamTokens(boolean usingStreamTokens) {
        this.usingStreamTokens = usingStreamTokens;
    }

    public boolean isUsingStreamTokens() {
        return this.usingStreamTokens;
    }

    @Override
    public <T> Mono<Boolean> existsById(Publisher<String> idPublisher, Class<T> entityClass) {
        return Flux.from(idPublisher).next().flatMap(id -> this.getDocument((String)id, entityClass, NAME_ONLY_MASK)).map(d -> true).switchIfEmpty(Mono.just((Object)false)).onErrorMap(throwable -> new FirestoreDataException("Unable to determine if document exists", (Throwable)throwable));
    }

    @Override
    public <T> Mono<T> findById(Publisher<String> idPublisher, Class<T> entityClass) {
        return this.findAllById(idPublisher, entityClass).next();
    }

    @Override
    public <T> Flux<T> findAllById(Publisher<String> idPublisher, Class<T> entityClass) {
        return Flux.from(idPublisher).flatMap(id -> this.getDocument((String)id, entityClass, null)).onErrorMap(throwable -> new FirestoreDataException("Error while reading entries by id", (Throwable)throwable)).map(document -> this.getClassMapper().documentToEntity((Document)document, entityClass));
    }

    @Override
    public <T> Mono<T> save(T entity) {
        return this.saveAll((Publisher<T>)Mono.just(entity)).next();
    }

    @Override
    public <T> Flux<T> saveAll(Publisher<T> instances) {
        return Mono.subscriberContext().flatMapMany(ctx -> {
            Optional transactionContext = ctx.getOrEmpty(TransactionContext.class);
            if (transactionContext.isPresent()) {
                ReactiveFirestoreResourceHolder holder = (ReactiveFirestoreResourceHolder)((Object)((Object)((TransactionContext)transactionContext.get()).getResources().get(this.firestore)));
                List<Write> writes = holder.getWrites();
                return Flux.from((Publisher)instances).doOnNext(t -> writes.add(this.createUpdateWrite(t)));
            }
            Flux inputs = Flux.from((Publisher)instances).bufferTimeout(this.writeBufferSize, this.writeBufferTimeout);
            return ObservableReactiveUtil.streamingBidirectionalCall(this::openWriteStream, inputs, this::buildWriteRequest);
        });
    }

    @Override
    public <T> Flux<T> findAll(Class<T> clazz) {
        return Flux.defer(() -> this.findAllDocuments(clazz).map(document -> this.getClassMapper().documentToEntity((Document)document, clazz)));
    }

    @Override
    public <T> Mono<Long> count(Class<T> entityClass) {
        return this.count(entityClass, null);
    }

    @Override
    public <T> Mono<Long> count(Class<T> entityClass, StructuredQuery.Builder queryBuilder) {
        return this.findAllDocuments(entityClass, ID_PROJECTION, queryBuilder).count();
    }

    @Override
    public <T> Mono<Long> deleteAll(Class<T> clazz) {
        return this.deleteDocumentsByName((Flux<String>)this.findAllDocuments(clazz).map(Document::getName)).count();
    }

    @Override
    public <T> Mono<Void> delete(Publisher<T> entityPublisher) {
        return this.deleteDocumentsByName((Flux<String>)Flux.from(entityPublisher).map(this::buildResourceName)).then();
    }

    @Override
    public <T> Mono<Void> deleteById(Publisher<String> idPublisher, Class entityClass) {
        return Mono.defer(() -> {
            FirestorePersistentEntity persistentEntity = (FirestorePersistentEntity)this.mappingContext.getPersistentEntity(entityClass);
            return this.deleteDocumentsByName((Flux<String>)Flux.from((Publisher)idPublisher).map(id -> this.buildResourceName(persistentEntity, (String)id))).then();
        });
    }

    @Override
    public <T> Flux<T> execute(StructuredQuery.Builder builder, Class<T> entityType) {
        return Flux.defer(() -> this.findAllDocuments(entityType, null, builder).map(document -> this.getClassMapper().documentToEntity((Document)document, entityType)));
    }

    public FirestoreMappingContext getMappingContext() {
        return this.mappingContext;
    }

    private Flux<String> deleteDocumentsByName(Flux<String> documentNames) {
        return Mono.subscriberContext().flatMapMany(ctx -> {
            Optional transactionContext = ctx.getOrEmpty(TransactionContext.class);
            if (transactionContext.isPresent()) {
                ReactiveFirestoreResourceHolder holder = (ReactiveFirestoreResourceHolder)((Object)((Object)((TransactionContext)transactionContext.get()).getResources().get(this.firestore)));
                List<Write> writes = holder.getWrites();
                return Flux.from((Publisher)documentNames).doOnNext(t -> writes.add(this.createDeleteWrite((String)t)));
            }
            return ObservableReactiveUtil.streamingBidirectionalCall(this::openWriteStream, documentNames.bufferTimeout(this.writeBufferSize, this.writeBufferTimeout), this::buildDeleteRequest);
        });
    }

    WriteRequest buildDeleteRequest(List<String> documentIds, WriteResponse writeResponse) {
        WriteRequest.Builder writeRequestBuilder = WriteRequest.newBuilder();
        if (this.isUsingStreamTokens()) {
            writeRequestBuilder.setStreamId(writeResponse.getStreamId()).setStreamToken(writeResponse.getStreamToken());
        }
        documentIds.stream().map(this::createDeleteWrite).forEach(arg_0 -> ((WriteRequest.Builder)writeRequestBuilder).addWrites(arg_0));
        return writeRequestBuilder.build();
    }

    private Write createDeleteWrite(String documentId) {
        return Write.newBuilder().setDelete(documentId).build();
    }

    private <T> Flux<Document> findAllDocuments(Class<T> clazz) {
        return this.findAllDocuments(clazz, null, null);
    }

    private <T> Flux<Document> findAllDocuments(Class<T> clazz, StructuredQuery.Projection projection, StructuredQuery.Builder queryBuilder) {
        return Mono.subscriberContext().flatMapMany(ctx -> {
            FirestorePersistentEntity persistentEntity = (FirestorePersistentEntity)this.mappingContext.getPersistentEntity(clazz);
            StructuredQuery.Builder builder = queryBuilder != null ? queryBuilder.clone() : StructuredQuery.newBuilder();
            builder.addFrom(StructuredQuery.CollectionSelector.newBuilder().setCollectionId(persistentEntity.collectionName()).build());
            if (projection != null) {
                builder.setSelect(projection);
            }
            RunQueryRequest.Builder requestBuilder = RunQueryRequest.newBuilder().setParent(this.parent).setStructuredQuery(builder.build());
            this.doIfTransaction((Context)ctx, resourceHolder -> requestBuilder.setTransaction(resourceHolder.getTransactionId()));
            return ObservableReactiveUtil.streamingCall(obs -> this.firestore.runQuery(requestBuilder.build(), obs)).filter(RunQueryResponse::hasDocument).map(RunQueryResponse::getDocument);
        });
    }

    private Mono<Document> getDocument(String id, Class aClass, DocumentMask documentMask) {
        return Mono.subscriberContext().flatMap(ctx -> {
            FirestorePersistentEntity persistentEntity = (FirestorePersistentEntity)this.mappingContext.getPersistentEntity(aClass);
            GetDocumentRequest.Builder builder = GetDocumentRequest.newBuilder().setName(this.buildResourceName(persistentEntity, id));
            this.doIfTransaction((Context)ctx, holder -> builder.setTransaction(holder.getTransactionId()));
            if (documentMask != null) {
                builder.setMask(documentMask);
            }
            return ObservableReactiveUtil.unaryCall(obs -> this.firestore.getDocument(builder.build(), obs)).onErrorResume(throwable -> throwable.getMessage().startsWith(NOT_FOUND_DOCUMENT_MESSAGE), throwable -> Mono.empty());
        });
    }

    private void doIfTransaction(Context ctx, Consumer<ReactiveFirestoreResourceHolder> holderConsumer) {
        Optional transactionContext = ctx.getOrEmpty(TransactionContext.class);
        transactionContext.ifPresent(transactionCtx -> {
            ReactiveFirestoreResourceHolder holder = (ReactiveFirestoreResourceHolder)((Object)((Object)transactionCtx.getResources().get(this.firestore)));
            if (!holder.getWrites().isEmpty()) {
                throw new FirestoreDataException("Read operations are only allowed before write operations in a transaction");
            }
            holderConsumer.accept(holder);
        });
    }

    private StreamObserver<WriteRequest> openWriteStream(StreamObserver<WriteResponse> obs) {
        WriteRequest openStreamRequest = WriteRequest.newBuilder().setDatabase(this.databasePath).build();
        StreamObserver requestStreamObserver = this.firestore.write(obs);
        requestStreamObserver.onNext((Object)openStreamRequest);
        return requestStreamObserver;
    }

    <T> WriteRequest buildWriteRequest(List<T> entityList, WriteResponse writeResponse) {
        WriteRequest.Builder writeRequestBuilder = WriteRequest.newBuilder();
        if (this.isUsingStreamTokens()) {
            writeRequestBuilder.setStreamId(writeResponse.getStreamId()).setStreamToken(writeResponse.getStreamToken());
        }
        entityList.stream().map(this::createUpdateWrite).forEach(arg_0 -> ((WriteRequest.Builder)writeRequestBuilder).addWrites(arg_0));
        return writeRequestBuilder.build();
    }

    private <T> Write createUpdateWrite(T entity) {
        Write.Builder builder = Write.newBuilder();
        if (this.getIdValue(entity) == null) {
            builder.setCurrentDocument(Precondition.newBuilder().setExists(false).build());
        }
        String resourceName = this.buildResourceName(entity);
        Document document = this.getClassMapper().entityToDocument(entity, resourceName);
        return builder.setUpdate(document).build();
    }

    private <T> String buildResourceName(T entity) {
        FirestorePersistentEntity persistentEntity = (FirestorePersistentEntity)this.mappingContext.getPersistentEntity(entity.getClass());
        FirestorePersistentProperty idProperty = persistentEntity.getIdPropertyOrFail();
        Object idVal = persistentEntity.getPropertyAccessor(entity).getProperty((PersistentProperty)idProperty);
        if (idVal == null) {
            idVal = AutoId.autoId();
            persistentEntity.getPropertyAccessor(entity).setProperty((PersistentProperty)idProperty, idVal);
        }
        return this.buildResourceName(persistentEntity, idVal.toString());
    }

    private String buildResourceName(FirestorePersistentEntity<?> persistentEntity, String s) {
        return this.parent + "/" + persistentEntity.collectionName() + "/" + s;
    }

    private Object getIdValue(Object entity) {
        FirestorePersistentEntity persistentEntity = (FirestorePersistentEntity)this.mappingContext.getPersistentEntity(entity.getClass());
        FirestorePersistentProperty idProperty = persistentEntity.getIdPropertyOrFail();
        return persistentEntity.getPropertyAccessor(entity).getProperty((PersistentProperty)idProperty);
    }

    public FirestoreClassMapper getClassMapper() {
        return this.classMapper;
    }
}

