/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gcp.data.firestore.repository.support;

import java.util.Optional;
import org.springframework.cloud.gcp.data.firestore.FirestoreTemplate;
import org.springframework.cloud.gcp.data.firestore.SimpleFirestoreReactiveRepository;
import org.springframework.cloud.gcp.data.firestore.mapping.FirestoreMappingContext;
import org.springframework.cloud.gcp.data.firestore.mapping.FirestorePersistentEntity;
import org.springframework.cloud.gcp.data.firestore.mapping.FirestorePersistentEntityInformation;
import org.springframework.cloud.gcp.data.firestore.repository.support.FirestoreQueryLookupStrategy;
import org.springframework.data.repository.core.EntityInformation;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.core.support.ReactiveRepositoryFactorySupport;
import org.springframework.data.repository.query.QueryLookupStrategy;
import org.springframework.data.repository.query.QueryMethodEvaluationContextProvider;
import org.springframework.lang.Nullable;

public class ReactiveFirestoreRepositoryFactory
extends ReactiveRepositoryFactorySupport {
    private final FirestoreTemplate firestoreTemplate;
    private final FirestoreMappingContext firestoreMappingContext;

    public ReactiveFirestoreRepositoryFactory(FirestoreTemplate firestoreTemplate, FirestoreMappingContext firestoreMappingContext) {
        this.firestoreTemplate = firestoreTemplate;
        this.firestoreMappingContext = firestoreMappingContext;
    }

    public <T, ID> EntityInformation<T, ID> getEntityInformation(Class<T> aClass) {
        return new FirestorePersistentEntityInformation((FirestorePersistentEntity)this.firestoreMappingContext.getPersistentEntity(aClass));
    }

    protected Object getTargetRepository(RepositoryInformation repositoryInformation) {
        return this.getTargetRepositoryViaReflection(repositoryInformation, new Object[]{this.firestoreTemplate, repositoryInformation.getDomainType()});
    }

    protected Class<?> getRepositoryBaseClass(RepositoryMetadata repositoryMetadata) {
        return SimpleFirestoreReactiveRepository.class;
    }

    protected Optional<QueryLookupStrategy> getQueryLookupStrategy(@Nullable QueryLookupStrategy.Key key, QueryMethodEvaluationContextProvider evaluationContextProvider) {
        return Optional.of(new FirestoreQueryLookupStrategy(this.firestoreTemplate));
    }
}

