/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gcp.data.firestore.repository.query;

import com.google.firestore.v1.StructuredQuery;
import com.google.protobuf.Int32Value;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.cloud.gcp.core.util.MapBuilder;
import org.springframework.cloud.gcp.data.firestore.FirestoreDataException;
import org.springframework.cloud.gcp.data.firestore.FirestoreReactiveOperations;
import org.springframework.cloud.gcp.data.firestore.mapping.FirestoreMappingContext;
import org.springframework.cloud.gcp.data.firestore.mapping.FirestorePersistentEntity;
import org.springframework.cloud.gcp.data.firestore.mapping.FirestorePersistentProperty;
import org.springframework.cloud.gcp.data.firestore.mapping.PublicClassMapper;
import org.springframework.cloud.gcp.data.firestore.repository.query.FirestoreQueryMethod;
import org.springframework.data.domain.Pageable;
import org.springframework.data.repository.query.ParametersParameterAccessor;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.data.repository.query.ReturnedType;
import org.springframework.data.repository.query.parser.Part;
import org.springframework.data.repository.query.parser.PartTree;

public class PartTreeFirestoreQuery
implements RepositoryQuery {
    private final PartTree tree;
    private final FirestoreQueryMethod queryMethod;
    private final FirestoreReactiveOperations reactiveOperations;
    private final FirestorePersistentEntity<?> persistentEntity;
    private static final Map<Part.Type, StructuredQuery.FieldFilter.Operator> PART_TO_FILTER_OP = new MapBuilder().put((Object)Part.Type.SIMPLE_PROPERTY, (Object)StructuredQuery.FieldFilter.Operator.EQUAL).put((Object)Part.Type.GREATER_THAN_EQUAL, (Object)StructuredQuery.FieldFilter.Operator.GREATER_THAN_OR_EQUAL).put((Object)Part.Type.GREATER_THAN, (Object)StructuredQuery.FieldFilter.Operator.GREATER_THAN).put((Object)Part.Type.LESS_THAN_EQUAL, (Object)StructuredQuery.FieldFilter.Operator.LESS_THAN_OR_EQUAL).put((Object)Part.Type.LESS_THAN, (Object)StructuredQuery.FieldFilter.Operator.LESS_THAN).build();

    public PartTreeFirestoreQuery(FirestoreQueryMethod queryMethod, FirestoreReactiveOperations reactiveOperations, FirestoreMappingContext mappingContext) {
        this.queryMethod = queryMethod;
        this.reactiveOperations = reactiveOperations;
        ReturnedType returnedType = queryMethod.getResultProcessor().getReturnedType();
        this.tree = new PartTree(queryMethod.getName(), returnedType.getDomainType());
        this.persistentEntity = (FirestorePersistentEntity)mappingContext.getPersistentEntity(returnedType.getDomainType());
    }

    public Object execute(Object[] parameters) {
        ParametersParameterAccessor paramAccessor;
        Pageable pageable;
        List parts = this.tree.get().collect(Collectors.toList());
        if (parts.size() > 1 && parts.get(0) instanceof PartTree.OrPart) {
            throw new FirestoreDataException("Cloud Firestore only supports multiple filters combined with AND.");
        }
        StructuredQuery.Builder builder = this.createBuilderWithFilter(parameters);
        if (!this.getQueryMethod().getParameters().isEmpty() && (pageable = (paramAccessor = new ParametersParameterAccessor(this.getQueryMethod().getParameters(), parameters)).getPageable()) != null && pageable.isPaged()) {
            builder.setOffset((int)Math.min(Integer.MAX_VALUE, pageable.getOffset()));
            builder.setLimit(Int32Value.newBuilder().setValue(pageable.getPageSize()));
        }
        if (this.tree.isCountProjection()) {
            return this.reactiveOperations.count(this.persistentEntity.getType(), builder);
        }
        return this.reactiveOperations.execute(builder, this.persistentEntity.getType());
    }

    private StructuredQuery.Builder createBuilderWithFilter(Object[] parameters) {
        StructuredQuery.Builder builder = StructuredQuery.newBuilder();
        Iterator<Object> it = Arrays.asList(parameters).iterator();
        StructuredQuery.CompositeFilter.Builder compositeFilter = StructuredQuery.CompositeFilter.newBuilder();
        compositeFilter.setOp(StructuredQuery.CompositeFilter.Operator.AND);
        this.tree.getParts().forEach(part -> {
            FirestorePersistentProperty persistentProperty = (FirestorePersistentProperty)this.persistentEntity.getPersistentProperty(part.getProperty().getSegment());
            StructuredQuery.FieldReference fieldReference = StructuredQuery.FieldReference.newBuilder().setFieldPath(persistentProperty.getName()).build();
            StructuredQuery.Filter.Builder filter = StructuredQuery.Filter.newBuilder();
            if (part.getType() == Part.Type.IS_NULL) {
                filter.getUnaryFilterBuilder().setField(fieldReference).setOp(StructuredQuery.UnaryFilter.Operator.IS_NULL);
            } else {
                if (!it.hasNext()) {
                    throw new FirestoreDataException("Too few parameters are provided for query method: " + this.getQueryMethod().getName());
                }
                StructuredQuery.FieldFilter.Operator filterOp = PART_TO_FILTER_OP.get(part.getType());
                if (filterOp == null) {
                    throw new FirestoreDataException("Unsupported predicate keyword: " + part.getType());
                }
                filter.getFieldFilterBuilder().setField(fieldReference).setOp(filterOp).setValue(PublicClassMapper.convertToFirestoreValue(it.next()));
            }
            compositeFilter.addFilters(filter.build());
        });
        builder.setWhere(StructuredQuery.Filter.newBuilder().setCompositeFilter(compositeFilter.build()));
        return builder;
    }

    public QueryMethod getQueryMethod() {
        return this.queryMethod;
    }
}

