/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gcp.data.firestore.mapping;

import java.lang.annotation.Annotation;
import org.springframework.cloud.gcp.data.firestore.Document;
import org.springframework.cloud.gcp.data.firestore.FirestoreDataException;
import org.springframework.cloud.gcp.data.firestore.mapping.FirestorePersistentEntity;
import org.springframework.cloud.gcp.data.firestore.mapping.FirestorePersistentProperty;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.data.mapping.model.BasicPersistentEntity;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.StringUtils;

public class FirestorePersistentEntityImpl<T>
extends BasicPersistentEntity<T, FirestorePersistentProperty>
implements FirestorePersistentEntity<T> {
    private final String collectionName;

    public FirestorePersistentEntityImpl(TypeInformation<T> information) {
        super(information);
        this.collectionName = FirestorePersistentEntityImpl.getEntityCollectionName(information);
    }

    @Override
    public String collectionName() {
        return this.collectionName;
    }

    @Override
    public FirestorePersistentProperty getIdPropertyOrFail() {
        if (!this.hasIdProperty()) {
            throw new FirestoreDataException("An ID property was required but does not exist for the type: " + this.getType());
        }
        return (FirestorePersistentProperty)this.getIdProperty();
    }

    private static <T> String getEntityCollectionName(TypeInformation<T> typeInformation) {
        Document document = (Document)AnnotationUtils.findAnnotation((Class)typeInformation.getType(), Document.class);
        String collectionName = (String)AnnotationUtils.getValue((Annotation)document, (String)"collectionName");
        if (StringUtils.isEmpty((Object)collectionName)) {
            return StringUtils.uncapitalize((String)typeInformation.getType().getSimpleName());
        }
        return collectionName;
    }
}

