/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gcp.data.datastore.core.convert;

import com.google.cloud.datastore.BaseEntity;
import org.springframework.cloud.gcp.data.datastore.core.convert.ReadWriteConversions;
import org.springframework.cloud.gcp.data.datastore.core.mapping.DatastoreDataException;
import org.springframework.cloud.gcp.data.datastore.core.mapping.DatastorePersistentProperty;
import org.springframework.cloud.gcp.data.datastore.core.mapping.EmbeddedType;
import org.springframework.core.convert.ConversionException;
import org.springframework.data.mapping.model.PropertyValueProvider;
import org.springframework.data.util.TypeInformation;

public class EntityPropertyValueProvider
implements PropertyValueProvider<DatastorePersistentProperty> {
    private final BaseEntity entity;
    private final ReadWriteConversions conversion;

    public EntityPropertyValueProvider(BaseEntity entity, ReadWriteConversions readWriteConversions) {
        if (entity == null) {
            throw new DatastoreDataException("A non-null entity is required");
        }
        this.entity = entity;
        this.conversion = readWriteConversions;
    }

    public <T> T getPropertyValue(DatastorePersistentProperty persistentProperty) {
        if (persistentProperty.isIdProperty()) {
            return this.conversion.convertOnRead((Object)this.entity.getKey(), EmbeddedType.NOT_EMBEDDED, persistentProperty.getTypeInformation());
        }
        if (!persistentProperty.isColumnBacked()) {
            return null;
        }
        return this.getPropertyValue(persistentProperty.getFieldName(), persistentProperty.getEmbeddedType(), persistentProperty.getTypeInformation());
    }

    public <T> T getPropertyValue(String fieldName, EmbeddedType embeddedType, TypeInformation targetTypeInformation) {
        if (!this.entity.contains(fieldName)) {
            return null;
        }
        try {
            return this.conversion.convertOnRead(this.entity.getValue(fieldName).get(), embeddedType, targetTypeInformation);
        }
        catch (DatastoreDataException | ConversionException ex) {
            throw new DatastoreDataException("Unable to read property " + fieldName, (Throwable)ex);
        }
    }
}

