/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gcp.data.datastore.repository.query;

import com.google.cloud.datastore.Cursor;
import com.google.cloud.datastore.EntityQuery;
import com.google.cloud.datastore.Key;
import com.google.cloud.datastore.KeyValue;
import com.google.cloud.datastore.ProjectionEntityQuery;
import com.google.cloud.datastore.Query;
import com.google.cloud.datastore.StructuredQuery;
import com.google.cloud.datastore.Value;
import java.beans.PropertyDescriptor;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.springframework.cloud.gcp.core.util.MapBuilder;
import org.springframework.cloud.gcp.data.datastore.core.DatastoreQueryOptions;
import org.springframework.cloud.gcp.data.datastore.core.DatastoreResultsIterable;
import org.springframework.cloud.gcp.data.datastore.core.DatastoreTemplate;
import org.springframework.cloud.gcp.data.datastore.core.mapping.DatastoreDataException;
import org.springframework.cloud.gcp.data.datastore.core.mapping.DatastoreMappingContext;
import org.springframework.cloud.gcp.data.datastore.core.mapping.DatastorePersistentEntity;
import org.springframework.cloud.gcp.data.datastore.core.mapping.DatastorePersistentProperty;
import org.springframework.cloud.gcp.data.datastore.repository.query.AbstractDatastoreQuery;
import org.springframework.cloud.gcp.data.datastore.repository.query.DatastorePageable;
import org.springframework.cloud.gcp.data.datastore.repository.query.DatastoreQueryMethod;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Slice;
import org.springframework.data.domain.SliceImpl;
import org.springframework.data.domain.Sort;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.projection.ProjectionInformation;
import org.springframework.data.repository.query.ParametersParameterAccessor;
import org.springframework.data.repository.query.parser.Part;
import org.springframework.data.repository.query.parser.PartTree;
import org.springframework.util.Assert;

public class PartTreeDatastoreQuery<T>
extends AbstractDatastoreQuery<T> {
    private final PartTree tree;
    private final DatastorePersistentEntity datastorePersistentEntity;
    private final ProjectionFactory projectionFactory;
    private List<Part> filterParts;
    private static final Map<Part.Type, BiFunction<String, Value, StructuredQuery.PropertyFilter>> FILTER_FACTORIES = new MapBuilder().put((Object)Part.Type.SIMPLE_PROPERTY, StructuredQuery.PropertyFilter::eq).put((Object)Part.Type.GREATER_THAN_EQUAL, StructuredQuery.PropertyFilter::ge).put((Object)Part.Type.GREATER_THAN, StructuredQuery.PropertyFilter::gt).put((Object)Part.Type.LESS_THAN_EQUAL, StructuredQuery.PropertyFilter::le).put((Object)Part.Type.LESS_THAN, StructuredQuery.PropertyFilter::lt).build();

    public PartTreeDatastoreQuery(DatastoreQueryMethod queryMethod, DatastoreTemplate datastoreTemplate, DatastoreMappingContext datastoreMappingContext, Class<T> entityType, ProjectionFactory projectionFactory) {
        super(queryMethod, datastoreTemplate, datastoreMappingContext, entityType);
        this.tree = new PartTree(queryMethod.getName(), entityType);
        this.datastorePersistentEntity = (DatastorePersistentEntity)this.datastoreMappingContext.getPersistentEntity(this.entityType);
        this.projectionFactory = projectionFactory;
        this.validateAndSetFilterParts();
    }

    private void validateAndSetFilterParts() {
        if (this.tree.isDistinct()) {
            throw new UnsupportedOperationException("Cloud Datastore structured queries do not support the Distinct keyword.");
        }
        List parts = this.tree.get().collect(Collectors.toList());
        if (parts.size() > 0) {
            if (parts.size() > 1) {
                throw new DatastoreDataException("Cloud Datastore only supports multiple filters combined with AND.");
            }
            this.filterParts = this.tree.getParts().get().collect(Collectors.toList());
        } else {
            this.filterParts = Collections.emptyList();
        }
    }

    public Object execute(Object[] parameters) {
        Class returnedObjectType = this.getQueryMethod().getReturnedObjectType();
        if (this.isPageQuery()) {
            Long totalCount;
            ExecutionResult executionResult = (ExecutionResult)this.runQuery(parameters, returnedObjectType, List.class, false);
            List resultEntries = (List)executionResult.getPayload();
            ParametersParameterAccessor paramAccessor = new ParametersParameterAccessor(this.getQueryMethod().getParameters(), parameters);
            Pageable pageableParam = paramAccessor.getPageable();
            if (pageableParam instanceof DatastorePageable) {
                Long previousCount = ((DatastorePageable)pageableParam).getTotalCount();
                Assert.notNull((Object)previousCount, (String)"Previous total count can not be null.");
                totalCount = ((DatastorePageable)pageableParam).getTotalCount();
            } else {
                totalCount = (Long)this.runQuery(parameters, Long.class, null, true);
            }
            Pageable pageable = DatastorePageable.from(pageableParam, executionResult.getCursor(), totalCount);
            return new PageImpl(resultEntries, pageable, totalCount.longValue());
        }
        if (this.isSliceQuery()) {
            return this.executeSliceQuery(parameters);
        }
        Object result = this.runQuery(parameters, returnedObjectType, ((DatastoreQueryMethod)this.getQueryMethod()).getCollectionReturnType(), false);
        Object object = result = result instanceof ExecutionResult ? ((ExecutionResult)result).getPayload() : result;
        if (result == null && ((DatastoreQueryMethod)this.getQueryMethod()).isOptionalReturnType()) {
            return Optional.empty();
        }
        return result;
    }

    private Object runQuery(Object[] parameters, Class returnedElementType, Class<?> collectionType, boolean requiresCount) {
        ExecutionOptions options = new ExecutionOptions(returnedElementType, collectionType, requiresCount);
        DatastoreResultsIterable<?> rawResults = this.getDatastoreTemplate().queryKeysOrEntities((Query)this.applyQueryBody(parameters, options.getQueryBuilder(), requiresCount, options.isSingularResult(), null), this.entityType);
        Object result = StreamSupport.stream(rawResults.spliterator(), false).map(options.isReturnedTypeIsNumber() ? Function.identity() : this::processRawObjectForProjection).collect(options.getResultsCollector());
        if (this.tree.isDelete()) {
            this.deleteFoundEntities(options.isReturnedTypeIsNumber(), (Iterable)result);
        }
        if (!this.tree.isExistsProjection() && !options.isCountingQuery()) {
            return new ExecutionResult(this.convertResultCollection(result, collectionType), rawResults.getCursor());
        }
        if (options.isCountingQuery() && this.tree.isDelete()) {
            return ((List)result).size();
        }
        return result;
    }

    private StructuredQuery.Builder<?> getEntityOrProjectionQueryBuilder() {
        ProjectionInformation projectionInformation = this.projectionFactory.getProjectionInformation(this.queryMethod.getReturnedObjectType());
        if (projectionInformation != null && projectionInformation.getType() != this.entityType && projectionInformation.isClosed()) {
            ProjectionEntityQuery.Builder projectionEntityQueryBuilder = Query.newProjectionEntityQueryBuilder();
            projectionInformation.getInputProperties().forEach(propertyDescriptor -> projectionEntityQueryBuilder.addProjection(this.mapToFieldName((PropertyDescriptor)propertyDescriptor), new String[0]));
            return projectionEntityQueryBuilder;
        }
        return StructuredQuery.newEntityQueryBuilder();
    }

    private String mapToFieldName(PropertyDescriptor propertyDescriptor) {
        String name = propertyDescriptor.getName();
        DatastorePersistentProperty persistentProperty = (DatastorePersistentProperty)this.datastorePersistentEntity.getPersistentProperty(name);
        return persistentProperty.getFieldName();
    }

    private Slice executeSliceQuery(Object[] parameters) {
        StructuredQuery.Builder builder = this.getEntityOrProjectionQueryBuilder().setKind(this.datastorePersistentEntity.kindName());
        StructuredQuery query = this.applyQueryBody(parameters, builder, false, false, null);
        DatastoreResultsIterable<?> resultList = this.datastoreTemplate.queryKeysOrEntities((Query)query, this.entityType);
        ParametersParameterAccessor paramAccessor = new ParametersParameterAccessor(this.getQueryMethod().getParameters(), parameters);
        Pageable pageable = DatastorePageable.from(paramAccessor.getPageable(), resultList.getCursor(), null);
        EntityQuery.Builder builderNext = (EntityQuery.Builder)Query.newEntityQueryBuilder().setKind(this.datastorePersistentEntity.kindName());
        StructuredQuery queryNext = this.applyQueryBody(parameters, (StructuredQuery.Builder)builderNext, false, true, resultList.getCursor());
        Iterable datastoreResultsList = this.datastoreTemplate.query((Query)queryNext, x -> x);
        List result = StreamSupport.stream(resultList.spliterator(), false).collect(Collectors.toList());
        return (Slice)this.processRawObjectForProjection(new SliceImpl(result, pageable, !datastoreResultsList.isEmpty()));
    }

    Object convertResultCollection(Object result, Class<?> collectionType) {
        if (collectionType == null) {
            List list = (List)result;
            return list.isEmpty() ? null : list.get(0);
        }
        return this.getDatastoreTemplate().getDatastoreEntityConverter().getConversions().convertOnRead(result, collectionType, this.getQueryMethod().getReturnedObjectType());
    }

    private void deleteFoundEntities(boolean deleteById, Iterable rawResults) {
        if (deleteById) {
            this.getDatastoreTemplate().deleteAllById(rawResults, this.entityType);
        } else {
            this.getDatastoreTemplate().deleteAll(rawResults);
        }
    }

    private StructuredQuery applyQueryBody(Object[] parameters, StructuredQuery.Builder builder, boolean total, boolean singularResult, Cursor cursor) {
        ParametersParameterAccessor paramAccessor = new ParametersParameterAccessor(this.getQueryMethod().getParameters(), parameters);
        if (this.tree.hasPredicate()) {
            this.applySelectWithFilter(parameters, builder);
        }
        Pageable pageable = paramAccessor.getPageable();
        Integer limit = null;
        Integer offset = null;
        if (singularResult || this.tree.isExistsProjection()) {
            limit = 1;
        } else if (this.tree.isLimiting()) {
            limit = this.tree.getMaxResults();
        }
        if (!singularResult && !total && pageable.isPaged()) {
            limit = pageable.getPageSize();
        }
        Sort sort = this.tree.getSort();
        if (this.getQueryMethod().getParameters().hasPageableParameter()) {
            sort = sort.and(pageable.getSort());
        }
        if (this.getQueryMethod().getParameters().hasSortParameter()) {
            sort = sort.and(paramAccessor.getSort());
        }
        if (pageable.isPaged() && !total) {
            offset = (int)pageable.getOffset();
        }
        Cursor cursorToApply = null;
        if (cursor != null) {
            cursorToApply = cursor;
        } else if (pageable instanceof DatastorePageable) {
            cursorToApply = ((DatastorePageable)pageable).toCursor();
        }
        DatastoreTemplate.applyQueryOptions(builder, new DatastoreQueryOptions.Builder().setLimit(limit).setOffset(offset).setSort(sort).setCursor(cursorToApply).build(), this.datastorePersistentEntity);
        return builder.build();
    }

    private void applySelectWithFilter(Object[] parameters, StructuredQuery.Builder builder) {
        Iterator<Object> it = Arrays.asList(parameters).iterator();
        StructuredQuery.Filter[] filters = (StructuredQuery.Filter[])this.filterParts.stream().map(part -> {
            List<DatastorePersistentProperty> propertiesChain = this.getPropertiesChain((Part)part);
            String fieldName = propertiesChain.stream().map(DatastorePersistentProperty::getFieldName).collect(Collectors.joining("."));
            if (part.getType() == Part.Type.IS_NULL) {
                return StructuredQuery.PropertyFilter.isNull((String)fieldName);
            }
            BiFunction<String, Value, StructuredQuery.PropertyFilter> filterFactory = FILTER_FACTORIES.get(part.getType());
            if (filterFactory == null) {
                throw new DatastoreDataException("Unsupported predicate keyword: " + part.getType());
            }
            if (!it.hasNext()) {
                throw new DatastoreDataException("Too few parameters are provided for query method: " + this.getQueryMethod().getName());
            }
            Value convertedValue = this.convertParam(propertiesChain.get(propertiesChain.size() - 1), it.next());
            return filterFactory.apply(fieldName, convertedValue);
        }).toArray(StructuredQuery.Filter[]::new);
        builder.setFilter((StructuredQuery.Filter)(filters.length > 1 ? StructuredQuery.CompositeFilter.and((StructuredQuery.Filter)filters[0], (StructuredQuery.Filter[])Arrays.copyOfRange(filters, 1, filters.length)) : filters[0]));
    }

    private List<DatastorePersistentProperty> getPropertiesChain(Part part) {
        Iterable iterable = () -> part.getProperty().iterator();
        return StreamSupport.stream(iterable.spliterator(), false).map(propertyPath -> (DatastorePersistentProperty)((DatastorePersistentEntity)this.datastoreMappingContext.getPersistentEntity(propertyPath.getOwningType())).getPersistentProperty(propertyPath.getSegment())).collect(Collectors.toList());
    }

    private Value convertParam(DatastorePersistentProperty persistentProperty, Object val) {
        if (persistentProperty.isAssociation() && this.datastoreMappingContext.hasPersistentEntityFor(val.getClass())) {
            return KeyValue.of((Key)this.datastoreTemplate.getKey(val));
        }
        if (persistentProperty.isIdProperty()) {
            return KeyValue.of((Key)this.datastoreTemplate.createKey(this.datastorePersistentEntity.kindName(), val));
        }
        return this.datastoreTemplate.getDatastoreEntityConverter().getConversions().convertOnWriteSingle(val);
    }

    private class ExecutionOptions {
        private boolean returnedTypeIsNumber;
        private boolean isCountingQuery;
        private StructuredQuery.Builder<?> structuredQueryBuilder;
        private boolean singularResult;

        ExecutionOptions(Class returnedElementType, Class<?> collectionType, boolean requiresCount) {
            this.returnedTypeIsNumber = Number.class.isAssignableFrom(returnedElementType) || returnedElementType == Integer.TYPE || returnedElementType == Long.TYPE;
            this.isCountingQuery = PartTreeDatastoreQuery.this.tree.isCountProjection() || PartTreeDatastoreQuery.this.tree.isDelete() && this.returnedTypeIsNumber || requiresCount;
            this.structuredQueryBuilder = (!this.isCountingQuery || PartTreeDatastoreQuery.this.tree.isDelete()) && !PartTreeDatastoreQuery.this.tree.isExistsProjection() && !this.returnedTypeIsNumber ? PartTreeDatastoreQuery.this.getEntityOrProjectionQueryBuilder() : StructuredQuery.newKeyQueryBuilder();
            this.structuredQueryBuilder.setKind(PartTreeDatastoreQuery.this.datastorePersistentEntity.kindName());
            this.singularResult = !this.isCountingQuery && collectionType == null && !PartTreeDatastoreQuery.this.tree.isDelete();
        }

        boolean isReturnedTypeIsNumber() {
            return this.returnedTypeIsNumber;
        }

        boolean isCountingQuery() {
            return this.isCountingQuery;
        }

        StructuredQuery.Builder<?> getQueryBuilder() {
            return this.structuredQueryBuilder;
        }

        boolean isSingularResult() {
            return this.singularResult;
        }

        private Collector<?, ?, ?> getResultsCollector() {
            Collector collector = Collectors.toList();
            if (this.isCountingQuery && !PartTreeDatastoreQuery.this.tree.isDelete()) {
                collector = Collectors.counting();
            } else if (PartTreeDatastoreQuery.this.tree.isExistsProjection()) {
                collector = Collectors.collectingAndThen(Collectors.counting(), count -> count > 0L);
            }
            return collector;
        }
    }

    private static class ExecutionResult {
        Object payload;
        Cursor cursor;

        ExecutionResult(Object result, Cursor cursor) {
            this.payload = result;
            this.cursor = cursor;
        }

        public Object getPayload() {
            return this.payload;
        }

        public Cursor getCursor() {
            return this.cursor;
        }
    }
}

