/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gcp.data.datastore.core.convert;

import com.google.cloud.datastore.Datastore;
import com.google.cloud.datastore.IncompleteKey;
import com.google.cloud.datastore.Key;
import com.google.cloud.datastore.KeyFactory;
import java.util.function.Supplier;
import org.springframework.cloud.gcp.data.datastore.core.DatastoreTemplate;
import org.springframework.cloud.gcp.data.datastore.core.convert.ObjectToKeyFactory;
import org.springframework.cloud.gcp.data.datastore.core.mapping.DatastoreDataException;
import org.springframework.cloud.gcp.data.datastore.core.mapping.DatastorePersistentEntity;
import org.springframework.cloud.gcp.data.datastore.core.mapping.DatastorePersistentProperty;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.util.Assert;

public class DatastoreServiceObjectToKeyFactory
implements ObjectToKeyFactory {
    private final Supplier<Datastore> datastore;

    public DatastoreServiceObjectToKeyFactory(Supplier<Datastore> datastore) {
        Assert.notNull(datastore, (String)"A non-null Datastore service is required.");
        this.datastore = datastore;
    }

    @Override
    public IncompleteKey getIncompleteKey(String kindName) {
        return ((KeyFactory)this.datastore.get().newKeyFactory().setKind(kindName)).newKey();
    }

    @Override
    public Key getKeyFromId(Object id, String kindName) {
        Key key;
        Assert.notNull((Object)id, (String)"Cannot get key for null ID value.");
        if (id instanceof Key) {
            return (Key)id;
        }
        KeyFactory keyFactory = this.getKeyFactory();
        keyFactory.setKind(kindName);
        if (id instanceof String) {
            key = keyFactory.newKey((String)id);
        } else if (id instanceof Long) {
            key = keyFactory.newKey(((Long)id).longValue());
        } else {
            throw new DatastoreDataException("Keys can only be created using String or long values.");
        }
        return key;
    }

    @Override
    public Key getKeyFromObject(Object entity, DatastorePersistentEntity datastorePersistentEntity) {
        Assert.notNull((Object)entity, (String)"Cannot get key for null entity object.");
        Assert.notNull((Object)datastorePersistentEntity, (String)"Persistent entity must not be null.");
        DatastorePersistentProperty idProp = datastorePersistentEntity.getIdPropertyOrFail();
        Object idVal = datastorePersistentEntity.getPropertyAccessor(entity).getProperty((PersistentProperty)idProp);
        if (idVal == null) {
            return null;
        }
        return this.getKeyFromId(idVal, datastorePersistentEntity.kindName());
    }

    @Override
    public Key allocateKeyForObject(Object entity, DatastorePersistentEntity datastorePersistentEntity, Key ... ancestors) {
        Assert.notNull((Object)entity, (String)"Cannot get key for null entity object.");
        Assert.notNull((Object)datastorePersistentEntity, (String)"Persistent entity must not be null.");
        DatastorePersistentProperty idProp = datastorePersistentEntity.getIdPropertyOrFail();
        Class idPropType = idProp.getType();
        if (!idPropType.equals(Key.class) && !idPropType.equals(Long.class)) {
            throw new DatastoreDataException("Cloud Datastore can only allocate IDs for Long and Key properties. Cannot allocate for type: " + idPropType);
        }
        KeyFactory keyFactory = (KeyFactory)this.getKeyFactory().setKind(datastorePersistentEntity.kindName());
        if (ancestors != null && ancestors.length > 0) {
            if (!idPropType.equals(Key.class)) {
                throw new DatastoreDataException("Only Key types are allowed for descendants id");
            }
            for (Key ancestor : ancestors) {
                keyFactory.addAncestor(DatastoreTemplate.keyToPathElement(ancestor));
            }
        }
        Key allocatedKey = this.datastore.get().allocateId(keyFactory.newKey());
        Object value = idPropType.equals(Key.class) ? allocatedKey : (idPropType.equals(Long.class) ? allocatedKey.getId() : allocatedKey.getId().toString());
        datastorePersistentEntity.getPropertyAccessor(entity).setProperty((PersistentProperty)idProp, value);
        return allocatedKey;
    }

    private KeyFactory getKeyFactory() {
        return this.datastore.get().newKeyFactory();
    }
}

