/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gcp.data.datastore.repository.config;

import java.lang.annotation.Annotation;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.cloud.gcp.data.datastore.repository.config.EnableDatastoreAuditing;
import org.springframework.cloud.gcp.data.datastore.repository.support.DatastoreAuditingEventListener;
import org.springframework.data.auditing.AuditingHandler;
import org.springframework.data.auditing.config.AuditingBeanDefinitionRegistrarSupport;
import org.springframework.data.auditing.config.AuditingConfiguration;

public class DatastoreAuditingRegistrar
extends AuditingBeanDefinitionRegistrarSupport {
    private static final String AUDITING_HANDLER_BEAN_NAME = "datastoreAuditingHandler";
    private static final String MAPPING_CONTEXT_BEAN_NAME = "datastoreMappingContext";

    protected Class<? extends Annotation> getAnnotation() {
        return EnableDatastoreAuditing.class;
    }

    protected void registerAuditListenerBeanDefinition(BeanDefinition auditingHandlerDefinition, BeanDefinitionRegistry registry) {
        Class<DatastoreAuditingEventListener> listenerClass = DatastoreAuditingEventListener.class;
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(listenerClass).addConstructorArgReference(AUDITING_HANDLER_BEAN_NAME);
        this.registerInfrastructureBeanWithId(builder.getRawBeanDefinition(), listenerClass.getName(), registry);
    }

    protected BeanDefinitionBuilder getAuditHandlerBeanDefinitionBuilder(AuditingConfiguration configuration) {
        BeanDefinitionBuilder builder = this.configureDefaultAuditHandlerAttributes(configuration, BeanDefinitionBuilder.rootBeanDefinition(AuditingHandler.class));
        return builder.addConstructorArgReference(MAPPING_CONTEXT_BEAN_NAME);
    }

    protected String getAuditingHandlerBeanName() {
        return AUDITING_HANDLER_BEAN_NAME;
    }
}

