/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gcp.data.datastore.core.mapping;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.cloud.gcp.data.datastore.core.mapping.DatastoreDataException;
import org.springframework.cloud.gcp.data.datastore.core.mapping.DatastorePersistentEntity;
import org.springframework.cloud.gcp.data.datastore.core.mapping.DatastorePersistentProperty;
import org.springframework.cloud.gcp.data.datastore.core.mapping.Entity;
import org.springframework.context.ApplicationContext;
import org.springframework.context.expression.BeanFactoryAccessor;
import org.springframework.context.expression.BeanFactoryResolver;
import org.springframework.data.mapping.PropertyHandler;
import org.springframework.data.mapping.model.BasicPersistentEntity;
import org.springframework.data.util.TypeInformation;
import org.springframework.expression.BeanResolver;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.ParserContext;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.common.LiteralExpression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;

public class DatastorePersistentEntityImpl<T>
extends BasicPersistentEntity<T, DatastorePersistentProperty>
implements DatastorePersistentEntity<T> {
    private static final ExpressionParser PARSER = new SpelExpressionParser();
    private final Expression kindNameExpression;
    private final String kindName;
    private final Entity kind;
    private StandardEvaluationContext context;

    public DatastorePersistentEntityImpl(TypeInformation<T> information) {
        super(information);
        Class rawType = information.getType();
        this.context = new StandardEvaluationContext();
        this.kind = (Entity)this.findAnnotation(Entity.class);
        this.kindName = this.hasTableName() ? this.kind.name() : StringUtils.uncapitalize((String)rawType.getSimpleName());
        this.kindNameExpression = this.detectExpression();
    }

    protected boolean hasTableName() {
        return this.kind != null && StringUtils.hasText((String)this.kind.name());
    }

    @Nullable
    private Expression detectExpression() {
        if (!this.hasTableName()) {
            return null;
        }
        Expression expression = PARSER.parseExpression(this.kind.name(), ParserContext.TEMPLATE_EXPRESSION);
        return expression instanceof LiteralExpression ? null : expression;
    }

    @Override
    public String kindName() {
        return this.kindNameExpression == null ? this.kindName : (String)this.kindNameExpression.getValue((EvaluationContext)this.context, String.class);
    }

    @Override
    public DatastorePersistentProperty getIdPropertyOrFail() {
        if (!this.hasIdProperty()) {
            throw new DatastoreDataException("An ID property was required but does not exist for the type: " + this.getType());
        }
        return (DatastorePersistentProperty)this.getIdProperty();
    }

    @Override
    public void doWithColumnBackedProperties(PropertyHandler<DatastorePersistentProperty> handler) {
        this.doWithProperties(datastorePersistentProperty -> {
            if (datastorePersistentProperty.isColumnBacked()) {
                handler.doWithPersistentProperty(datastorePersistentProperty);
            }
        });
    }

    @Override
    public void doWithDescendantProperties(PropertyHandler<DatastorePersistentProperty> handler) {
        this.doWithProperties(datastorePersistentProperty -> {
            if (datastorePersistentProperty.isDescendants()) {
                handler.doWithPersistentProperty(datastorePersistentProperty);
            }
        });
    }

    @Override
    public void doWithReferenceProperties(PropertyHandler<DatastorePersistentProperty> handler) {
        this.doWithProperties(datastorePersistentProperty -> {
            if (datastorePersistentProperty.isReference()) {
                handler.doWithPersistentProperty(datastorePersistentProperty);
            }
        });
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context.addPropertyAccessor((PropertyAccessor)new BeanFactoryAccessor());
        this.context.setBeanResolver((BeanResolver)new BeanFactoryResolver((BeanFactory)applicationContext));
        this.context.setRootObject((Object)applicationContext);
    }
}

