/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gcp.data.datastore.repository.query;

import com.google.cloud.datastore.EntityQuery;
import com.google.cloud.datastore.Query;
import com.google.cloud.datastore.StructuredQuery;
import com.google.cloud.datastore.Value;
import com.google.common.annotations.VisibleForTesting;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.springframework.cloud.gcp.data.datastore.core.DatastoreQueryOptions;
import org.springframework.cloud.gcp.data.datastore.core.DatastoreTemplate;
import org.springframework.cloud.gcp.data.datastore.core.convert.ReadWriteConversions;
import org.springframework.cloud.gcp.data.datastore.core.mapping.DatastoreDataException;
import org.springframework.cloud.gcp.data.datastore.core.mapping.DatastoreMappingContext;
import org.springframework.cloud.gcp.data.datastore.core.mapping.DatastorePersistentEntity;
import org.springframework.cloud.gcp.data.datastore.core.mapping.DatastorePersistentProperty;
import org.springframework.cloud.gcp.data.datastore.repository.query.AbstractDatastoreQuery;
import org.springframework.cloud.gcp.data.datastore.repository.query.DatastoreQueryMethod;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Slice;
import org.springframework.data.domain.SliceImpl;
import org.springframework.data.domain.Sort;
import org.springframework.data.repository.query.ParametersParameterAccessor;
import org.springframework.data.repository.query.parser.Part;
import org.springframework.data.repository.query.parser.PartTree;

public class PartTreeDatastoreQuery<T>
extends AbstractDatastoreQuery<T> {
    private final PartTree tree;
    private final DatastorePersistentEntity datastorePersistentEntity;
    private List<Part> filterParts;

    public PartTreeDatastoreQuery(DatastoreQueryMethod queryMethod, DatastoreTemplate datastoreTemplate, DatastoreMappingContext datastoreMappingContext, Class<T> entityType) {
        super(queryMethod, datastoreTemplate, datastoreMappingContext, entityType);
        this.tree = new PartTree(queryMethod.getName(), entityType);
        this.datastorePersistentEntity = (DatastorePersistentEntity)this.datastoreMappingContext.getPersistentEntity(this.entityType);
        this.validateAndSetFilterParts();
    }

    private void validateAndSetFilterParts() {
        if (this.tree.isDistinct()) {
            throw new UnsupportedOperationException("Cloud Datastore structured queries do not support the Distinct keyword.");
        }
        List parts = this.tree.get().collect(Collectors.toList());
        if (parts.size() > 0) {
            if (parts.get(0) instanceof PartTree.OrPart && parts.size() > 1) {
                throw new DatastoreDataException("Cloud Datastore only supports multiple filters combined with AND.");
            }
            this.filterParts = this.tree.getParts().get().collect(Collectors.toList());
        } else {
            this.filterParts = Collections.emptyList();
        }
    }

    public Object execute(Object[] parameters) {
        Class returnedObjectType = this.getQueryMethod().getReturnedObjectType();
        if (this.isPageQuery()) {
            List resultEntries = (List)this.execute(parameters, returnedObjectType, List.class, false);
            Long totalCount = (Long)this.execute(parameters, Long.class, null, true);
            ParametersParameterAccessor paramAccessor = new ParametersParameterAccessor(this.getQueryMethod().getParameters(), parameters);
            return new PageImpl(resultEntries, paramAccessor.getPageable(), totalCount.longValue());
        }
        if (this.isSliceQuery()) {
            return this.executeSliceQuery(parameters);
        }
        return this.execute(parameters, returnedObjectType, ((DatastoreQueryMethod)this.getQueryMethod()).getCollectionReturnType(), false);
    }

    @VisibleForTesting
    protected boolean isPageQuery() {
        return this.getQueryMethod().isPageQuery();
    }

    @VisibleForTesting
    protected boolean isSliceQuery() {
        return this.getQueryMethod().isSliceQuery();
    }

    private Object execute(Object[] parameters, Class returnedElementType, Class<?> collectionType, boolean total) {
        Supplier<StructuredQuery.Builder> queryBuilderSupplier = Query::newKeyQueryBuilder;
        Function<Object, Object> mapper = Function.identity();
        boolean returnedTypeIsNumber = Number.class.isAssignableFrom(returnedElementType) || returnedElementType == Integer.TYPE || returnedElementType == Long.TYPE;
        boolean isCountingQuery = this.tree.isCountProjection() || this.tree.isDelete() && returnedTypeIsNumber || total;
        Collector collector = Collectors.toList();
        if (isCountingQuery && !this.tree.isDelete()) {
            collector = Collectors.counting();
        } else if (this.tree.isExistsProjection()) {
            collector = Collectors.collectingAndThen(Collectors.counting(), count -> count > 0L);
        } else if (!returnedTypeIsNumber) {
            queryBuilderSupplier = Query::newEntityQueryBuilder;
            mapper = this::processRawObjectForProjection;
        }
        StructuredQuery.Builder structredQueryBuilder = queryBuilderSupplier.get();
        structredQueryBuilder.setKind(this.datastorePersistentEntity.kindName());
        Iterable<?> rawResults = this.getDatastoreTemplate().queryKeysOrEntities((Query)this.applyQueryBody(parameters, structredQueryBuilder, total), this.entityType);
        List result = StreamSupport.stream(rawResults.spliterator(), false).map(mapper).collect(collector);
        if (this.tree.isDelete()) {
            this.deleteFoundEntities(returnedTypeIsNumber, result);
            if (isCountingQuery) {
                return result.size();
            }
        }
        return this.tree.isExistsProjection() || isCountingQuery ? result : this.convertResultCollection(result, collectionType);
    }

    private Slice executeSliceQuery(Object[] parameters) {
        EntityQuery.Builder builder = (EntityQuery.Builder)StructuredQuery.newEntityQueryBuilder().setKind(this.datastorePersistentEntity.kindName());
        StructuredQuery query = this.applyQueryBody(parameters, (StructuredQuery.Builder)builder, false);
        List items = this.datastoreTemplate.query((Query)query, x -> x);
        Integer limit = query.getLimit() == null ? null : Integer.valueOf(query.getLimit() - 1);
        boolean exceedsLimit = false;
        if (limit != null) {
            boolean bl = exceedsLimit = items.size() > limit;
            if (exceedsLimit) {
                items = items.subList(0, limit);
            }
        }
        ParametersParameterAccessor paramAccessor = new ParametersParameterAccessor(this.getQueryMethod().getParameters(), parameters);
        Pageable pageable = paramAccessor.getPageable();
        List entities = this.datastoreTemplate.convertEntitiesForRead(items.iterator(), this.entityType).stream().map(o -> this.processRawObjectForProjection(o)).collect(Collectors.toList());
        return new SliceImpl(entities, pageable, exceedsLimit);
    }

    @VisibleForTesting
    protected Object convertResultCollection(Object result, Class<?> collectionType) {
        return this.getDatastoreTemplate().getDatastoreEntityConverter().getConversions().convertOnRead(result, collectionType, this.getQueryMethod().getReturnedObjectType());
    }

    private void deleteFoundEntities(boolean returnedTypeIsNumber, Iterable rawResults) {
        if (returnedTypeIsNumber) {
            this.getDatastoreTemplate().deleteAllById(rawResults, this.entityType);
        } else {
            this.getDatastoreTemplate().deleteAll(rawResults);
        }
    }

    private StructuredQuery applyQueryBody(Object[] parameters, StructuredQuery.Builder builder, boolean total) {
        ParametersParameterAccessor paramAccessor = new ParametersParameterAccessor(this.getQueryMethod().getParameters(), parameters);
        if (this.tree.hasPredicate()) {
            this.applySelectWithFilter(parameters, builder);
        }
        Integer limit = null;
        Integer offset = null;
        if (this.tree.isExistsProjection()) {
            limit = 1;
        } else if (this.tree.isLimiting()) {
            limit = this.tree.getMaxResults();
        }
        Sort sort = this.tree.getSort();
        if (this.getQueryMethod().getParameters().hasPageableParameter()) {
            sort = sort.and(paramAccessor.getPageable().getSort());
        }
        if (this.getQueryMethod().getParameters().hasSortParameter()) {
            sort = sort.and(paramAccessor.getSort());
        }
        if (paramAccessor.getPageable().isPaged() && !total) {
            limit = paramAccessor.getPageable().getPageSize() + (this.isSliceQuery() ? 1 : 0);
            offset = (int)paramAccessor.getPageable().getOffset();
        }
        DatastoreTemplate.applyQueryOptions(builder, new DatastoreQueryOptions(limit, offset, sort), this.datastorePersistentEntity);
        return builder.build();
    }

    private void applySelectWithFilter(Object[] parameters, StructuredQuery.Builder builder) {
        Iterator<Object> it = Arrays.asList(parameters).iterator();
        HashSet equalityComparedFields = new HashSet();
        StructuredQuery.Filter[] filters = (StructuredQuery.Filter[])this.filterParts.stream().map(part -> {
            String fieldName = ((DatastorePersistentProperty)this.datastorePersistentEntity.getPersistentProperty(part.getProperty().getSegment())).getFieldName();
            try {
                StructuredQuery.PropertyFilter filter;
                ReadWriteConversions converter = this.datastoreTemplate.getDatastoreEntityConverter().getConversions();
                switch (part.getType()) {
                    case IS_NULL: {
                        filter = StructuredQuery.PropertyFilter.isNull((String)fieldName);
                        break;
                    }
                    case SIMPLE_PROPERTY: {
                        filter = StructuredQuery.PropertyFilter.eq((String)fieldName, (Value)converter.convertOnWriteSingle(it.next()));
                        equalityComparedFields.add(fieldName);
                        break;
                    }
                    case GREATER_THAN_EQUAL: {
                        filter = StructuredQuery.PropertyFilter.ge((String)fieldName, (Value)converter.convertOnWriteSingle(it.next()));
                        break;
                    }
                    case GREATER_THAN: {
                        filter = StructuredQuery.PropertyFilter.gt((String)fieldName, (Value)converter.convertOnWriteSingle(it.next()));
                        break;
                    }
                    case LESS_THAN_EQUAL: {
                        filter = StructuredQuery.PropertyFilter.le((String)fieldName, (Value)converter.convertOnWriteSingle(it.next()));
                        break;
                    }
                    case LESS_THAN: {
                        filter = StructuredQuery.PropertyFilter.lt((String)fieldName, (Value)converter.convertOnWriteSingle(it.next()));
                        break;
                    }
                    default: {
                        throw new DatastoreDataException("Unsupported predicate keyword: " + part.getType());
                    }
                }
                return filter;
            }
            catch (NoSuchElementException ex) {
                throw new DatastoreDataException("Too few parameters are provided for query method: " + this.getQueryMethod().getName());
            }
        }).toArray(StructuredQuery.Filter[]::new);
        builder.setFilter((StructuredQuery.Filter)(filters.length > 1 ? StructuredQuery.CompositeFilter.and((StructuredQuery.Filter)filters[0], (StructuredQuery.Filter[])Arrays.copyOfRange(filters, 1, filters.length)) : filters[0]));
    }
}

