/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gcp.data.datastore.core;

import com.google.cloud.datastore.Datastore;
import com.google.cloud.datastore.DatastoreException;
import com.google.cloud.datastore.Entity;
import com.google.cloud.datastore.FullEntity;
import com.google.cloud.datastore.Key;
import com.google.cloud.datastore.Query;
import com.google.cloud.datastore.QueryResults;
import com.google.cloud.datastore.Transaction;
import com.google.common.annotations.VisibleForTesting;
import com.google.protobuf.ByteString;
import java.util.Iterator;
import java.util.List;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionException;
import org.springframework.transaction.TransactionSystemException;
import org.springframework.transaction.interceptor.TransactionAspectSupport;
import org.springframework.transaction.support.AbstractPlatformTransactionManager;
import org.springframework.transaction.support.DefaultTransactionStatus;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class DatastoreTransactionManager
extends AbstractPlatformTransactionManager {
    private final Datastore datastore;

    public DatastoreTransactionManager(Datastore datastore) {
        this.datastore = datastore;
    }

    @VisibleForTesting
    Tx getCurrentTX() {
        return TransactionSynchronizationManager.isActualTransactionActive() ? (Tx)((DefaultTransactionStatus)TransactionAspectSupport.currentTransactionStatus()).getTransaction() : null;
    }

    protected Object doGetTransaction() throws TransactionException {
        Tx tx = this.getCurrentTX();
        if (tx != null && tx.transaction != null && tx.transaction.isActive()) {
            return tx;
        }
        tx = new Tx();
        return tx;
    }

    protected void doBegin(Object transactionObject, TransactionDefinition transactionDefinition) throws TransactionException {
        if (transactionDefinition.getIsolationLevel() != -1 && transactionDefinition.getIsolationLevel() != 8) {
            throw new IllegalStateException("DatastoreTransactionManager supports only isolation level TransactionDefinition.ISOLATION_DEFAULT or ISOLATION_SERIALIZABLE");
        }
        if (transactionDefinition.getPropagationBehavior() != 0) {
            throw new IllegalStateException("DatastoreTransactionManager supports only propagation behavior TransactionDefinition.PROPAGATION_REQUIRED");
        }
        Tx tx = (Tx)transactionObject;
        Transaction transaction = this.datastore.newTransaction();
        if (transactionDefinition.isReadOnly()) {
            tx.transaction = new ReadOnlyTransaction(transaction);
        } else {
            tx.transaction = transaction;
        }
    }

    protected void doCommit(DefaultTransactionStatus defaultTransactionStatus) throws TransactionException {
        Tx tx = (Tx)defaultTransactionStatus.getTransaction();
        try {
            if (tx.transaction.isActive()) {
                tx.transaction.commit();
            } else {
                this.logger.debug((Object)"Transaction was not committed because it is no longer active.");
            }
        }
        catch (DatastoreException ex) {
            throw new TransactionSystemException("Cloud Datastore transaction failed to commit.", (Throwable)ex);
        }
    }

    protected void doRollback(DefaultTransactionStatus defaultTransactionStatus) throws TransactionException {
        Tx tx = (Tx)defaultTransactionStatus.getTransaction();
        try {
            if (tx.transaction.isActive()) {
                tx.transaction.rollback();
            } else {
                this.logger.debug((Object)"Transaction was not rolled back because it is no longer active.");
            }
        }
        catch (DatastoreException ex) {
            throw new TransactionSystemException("Cloud Datastore transaction failed to rollback.", (Throwable)ex);
        }
    }

    protected boolean isExistingTransaction(Object transaction) {
        return transaction == this.getCurrentTX();
    }

    private static final class ReadOnlyTransaction
    implements Transaction {
        private final Transaction transaction;

        private ReadOnlyTransaction(Transaction transaction) {
            this.transaction = transaction;
        }

        public Entity get(Key key) {
            return this.transaction.get(key);
        }

        public Iterator<Entity> get(Key ... key) {
            return this.transaction.get(key);
        }

        public List<Entity> fetch(Key ... keys) {
            return this.transaction.fetch(keys);
        }

        public <T> QueryResults<T> run(Query<T> query) {
            return this.transaction.run(query);
        }

        public void addWithDeferredIdAllocation(FullEntity<?> ... entities) {
            throw new UnsupportedOperationException("The Cloud Datastore transaction is in read-only mode.");
        }

        public Entity add(FullEntity<?> entity) {
            throw new UnsupportedOperationException("The Cloud Datastore transaction is in read-only mode.");
        }

        public List<Entity> add(FullEntity<?> ... entities) {
            throw new UnsupportedOperationException("The Cloud Datastore transaction is in read-only mode.");
        }

        public void update(Entity ... entities) {
            throw new UnsupportedOperationException("The Cloud Datastore transaction is in read-only mode.");
        }

        public void delete(Key ... keys) {
            throw new UnsupportedOperationException("The Cloud Datastore transaction is in read-only mode.");
        }

        public void putWithDeferredIdAllocation(FullEntity<?> ... entities) {
            throw new UnsupportedOperationException("The Cloud Datastore transaction is in read-only mode.");
        }

        public Entity put(FullEntity<?> entity) {
            throw new UnsupportedOperationException("The Cloud Datastore transaction is in read-only mode.");
        }

        public List<Entity> put(FullEntity<?> ... entities) {
            throw new UnsupportedOperationException("The Cloud Datastore transaction is in read-only mode.");
        }

        public Transaction.Response commit() {
            return this.transaction.commit();
        }

        public void rollback() {
            this.transaction.rollback();
        }

        public boolean isActive() {
            return this.transaction.isActive();
        }

        public Datastore getDatastore() {
            return this.transaction.getDatastore();
        }

        public ByteString getTransactionId() {
            return this.transaction.getTransactionId();
        }
    }

    public static class Tx {
        private Transaction transaction;

        public Transaction getTransaction() {
            return this.transaction;
        }

        @VisibleForTesting
        void setTransaction(Transaction transaction) {
            this.transaction = transaction;
        }
    }
}

