/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gcp.data.datastore.repository.query;

import com.google.cloud.datastore.BaseEntity;
import com.google.cloud.datastore.GqlQuery;
import com.google.cloud.datastore.Key;
import com.google.cloud.datastore.Query;
import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.springframework.cloud.gcp.data.datastore.core.DatastoreTemplate;
import org.springframework.cloud.gcp.data.datastore.core.convert.DatastoreNativeTypes;
import org.springframework.cloud.gcp.data.datastore.core.mapping.DatastoreDataException;
import org.springframework.cloud.gcp.data.datastore.core.mapping.DatastoreMappingContext;
import org.springframework.cloud.gcp.data.datastore.core.mapping.DatastorePersistentEntity;
import org.springframework.cloud.gcp.data.datastore.core.util.ValueUtil;
import org.springframework.cloud.gcp.data.datastore.repository.query.AbstractDatastoreQuery;
import org.springframework.cloud.gcp.data.datastore.repository.query.DatastoreQueryMethod;
import org.springframework.data.repository.query.Parameter;
import org.springframework.data.repository.query.Parameters;
import org.springframework.data.repository.query.QueryMethodEvaluationContextProvider;
import org.springframework.data.repository.query.SpelEvaluator;
import org.springframework.data.repository.query.SpelQueryContext;
import org.springframework.util.StringUtils;

public class GqlDatastoreQuery<T>
extends AbstractDatastoreQuery<T> {
    private static final String ENTITY_CLASS_NAME_BOOKEND = "|";
    private static final Pattern CLASS_NAME_PATTERN = Pattern.compile("\\|\\S+\\|");
    private final String originalGql;
    private String gqlResolvedEntityClassName;
    private List<String> originalParamTags;
    private QueryMethodEvaluationContextProvider evaluationContextProvider;
    private SpelQueryContext.EvaluatingSpelQueryContext evaluatingSpelQueryContext;

    public GqlDatastoreQuery(Class<T> type, DatastoreQueryMethod queryMethod, DatastoreTemplate datastoreTemplate, String gql, QueryMethodEvaluationContextProvider evaluationContextProvider, DatastoreMappingContext datastoreMappingContext) {
        super(queryMethod, datastoreTemplate, datastoreMappingContext, type);
        this.evaluationContextProvider = evaluationContextProvider;
        this.originalGql = StringUtils.trimTrailingCharacter((String)gql.trim(), (char)';');
        this.setOriginalParamTags();
        this.setEvaluatingSpelQueryContext();
        this.setGqlResolvedEntityClassName();
    }

    private static Object getNonEntityObjectFromRow(Object x) {
        Object mappedResult;
        if (x instanceof Key) {
            mappedResult = x;
        } else {
            BaseEntity entity = (BaseEntity)x;
            Set colNames = entity.getNames();
            if (colNames.size() > 1) {
                throw new DatastoreDataException("The query method returns non-entity types, but the query result has more than one column. Use a Projection entity type instead.");
            }
            mappedResult = entity.getValue((String)colNames.toArray()[0]).get();
        }
        return mappedResult;
    }

    public Object execute(Object[] parameters) {
        List rawResult;
        ParsedQueryWithTagsAndValues parsedQueryWithTagsAndValues = new ParsedQueryWithTagsAndValues(this.originalParamTags, parameters);
        GqlQuery<BaseEntity> query = this.bindArgsToGqlQuery(parsedQueryWithTagsAndValues.finalGql, parsedQueryWithTagsAndValues.tagsOrdered, parsedQueryWithTagsAndValues.params);
        boolean returnTypeIsCollection = this.queryMethod.isCollectionQuery();
        Class returnedItemType = this.queryMethod.getReturnedObjectType();
        boolean isNonEntityReturnType = this.isNonEntityReturnedType(returnedItemType);
        Iterable<?> found = isNonEntityReturnType ? this.datastoreTemplate.query((Query)query, GqlDatastoreQuery::getNonEntityObjectFromRow) : this.datastoreTemplate.queryKeysOrEntities((Query)query, this.entityType);
        List list = rawResult = found != null ? StreamSupport.stream(found.spliterator(), false).collect(Collectors.toList()) : Collections.emptyList();
        Object result = returnTypeIsCollection ? this.convertCollectionResult(returnedItemType, isNonEntityReturnType, rawResult) : (rawResult.isEmpty() ? null : this.convertSingularResult(returnedItemType, isNonEntityReturnType, rawResult));
        return result;
    }

    private Object convertCollectionResult(Class returnedItemType, boolean isNonEntityReturnType, List rawResult) {
        Object result = this.datastoreTemplate.getDatastoreEntityConverter().getConversions().convertOnRead((Object)(isNonEntityReturnType ? rawResult : this.applyProjection(rawResult)), this.queryMethod.getCollectionReturnType(), returnedItemType);
        return result;
    }

    private Object convertSingularResult(Class returnedItemType, boolean isNonEntityReturnType, List rawResult) {
        if (this.queryMethod.isCountQuery()) {
            return rawResult.size();
        }
        if (this.queryMethod.isExistsQuery()) {
            return !rawResult.isEmpty();
        }
        if (rawResult.size() > 1) {
            throw new DatastoreDataException("The query method returns a singular object but the query returned more than one result.");
        }
        return isNonEntityReturnType ? this.datastoreTemplate.getDatastoreEntityConverter().getConversions().convertOnRead(rawResult.get(0), null, returnedItemType) : this.queryMethod.getResultProcessor().processResult(rawResult.get(0));
    }

    @VisibleForTesting
    boolean isNonEntityReturnedType(Class returnedType) {
        return this.datastoreTemplate.getDatastoreEntityConverter().getConversions().getDatastoreCompatibleType(returnedType).isPresent();
    }

    private void setOriginalParamTags() {
        this.originalParamTags = new ArrayList<String>();
        HashSet<String> seen = new HashSet<String>();
        Parameters parameters = this.getQueryMethod().getParameters();
        for (int i = 0; i < parameters.getNumberOfParameters(); ++i) {
            Parameter param = parameters.getParameter(i);
            Optional paramName = param.getName();
            if (!paramName.isPresent()) {
                throw new DatastoreDataException("Query method has a parameter without a valid name: " + this.getQueryMethod().getName());
            }
            String name = (String)paramName.get();
            if (seen.contains(name)) {
                throw new DatastoreDataException("More than one param has the same name: " + name);
            }
            seen.add(name);
            this.originalParamTags.add(name);
        }
    }

    private GqlQuery<? extends BaseEntity> bindArgsToGqlQuery(String gql, List<String> tags, List vals) {
        GqlQuery.Builder builder = GqlQuery.newGqlQueryBuilder((String)gql);
        builder.setAllowLiteral(true);
        if (tags.size() != vals.size()) {
            throw new DatastoreDataException("Annotated GQL Query Method " + this.queryMethod.getName() + " has " + tags.size() + " tags but a different number of parameter values: " + vals.size());
        }
        for (int i = 0; i < tags.size(); ++i) {
            Object val = vals.get(i);
            Object boundVal = ValueUtil.isCollectionLike(val.getClass()) ? this.convertCollectionParamToCompatibleArray((List)ValueUtil.toListIfArray(val)) : this.datastoreTemplate.getDatastoreEntityConverter().getConversions().convertOnWriteSingle(val).get();
            DatastoreNativeTypes.bindValueToGqlBuilder(builder, tags.get(i), boundVal);
        }
        return builder.build();
    }

    private void setEvaluatingSpelQueryContext() {
        HashSet<String> originalTags = new HashSet<String>(this.originalParamTags);
        this.evaluatingSpelQueryContext = SpelQueryContext.EvaluatingSpelQueryContext.of((counter, spelExpression) -> {
            String newTag;
            do {
                Integer n = counter;
                Integer n2 = counter = Integer.valueOf(counter + 1);
            } while (originalTags.contains(newTag = "@SpELtag" + counter));
            originalTags.add(newTag);
            return newTag;
        }, (prefix, newTag) -> newTag).withEvaluationContextProvider(this.evaluationContextProvider);
    }

    private void setGqlResolvedEntityClassName() {
        Matcher matcher = CLASS_NAME_PATTERN.matcher(this.originalGql);
        String result = this.originalGql;
        while (matcher.find()) {
            String matched = matcher.group();
            String className = matched.substring(1, matched.length() - 1);
            try {
                Class<?> entityClass = Class.forName(className);
                DatastorePersistentEntity datastorePersistentEntity = (DatastorePersistentEntity)this.datastoreMappingContext.getPersistentEntity(entityClass);
                if (datastorePersistentEntity == null) {
                    throw new DatastoreDataException("The class used in the GQL statement is not a Cloud Datastore persistent entity: " + className);
                }
                result = result.replace(matched, datastorePersistentEntity.kindName());
            }
            catch (ClassNotFoundException ex) {
                throw new DatastoreDataException("The class name does not refer to an available entity type: " + className);
            }
        }
        this.gqlResolvedEntityClassName = result;
    }

    private class ParsedQueryWithTagsAndValues {
        final List<String> tagsOrdered;
        final Object[] rawParams;
        final List<Object> params;
        final String finalGql;

        ParsedQueryWithTagsAndValues(List<String> initialTags, Object[] rawParams) {
            this.params = new ArrayList<Object>(Arrays.asList(rawParams));
            this.rawParams = rawParams;
            this.tagsOrdered = new ArrayList<String>(initialTags);
            SpelEvaluator spelEvaluator = GqlDatastoreQuery.this.evaluatingSpelQueryContext.parse(GqlDatastoreQuery.this.gqlResolvedEntityClassName, GqlDatastoreQuery.this.queryMethod.getParameters());
            Map results = spelEvaluator.evaluate(this.rawParams);
            this.finalGql = spelEvaluator.getQueryString();
            for (Map.Entry entry : results.entrySet()) {
                this.params.add(entry.getValue());
                this.tagsOrdered.add(((String)entry.getKey()).substring(1));
            }
        }
    }
}

