/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gcp.data.datastore.repository.query;

import com.google.common.annotations.VisibleForTesting;
import java.lang.reflect.Array;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.cloud.gcp.data.datastore.core.DatastoreTemplate;
import org.springframework.cloud.gcp.data.datastore.core.mapping.DatastoreMappingContext;
import org.springframework.cloud.gcp.data.datastore.repository.query.DatastoreQueryMethod;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.repository.query.RepositoryQuery;

public abstract class AbstractDatastoreQuery<T>
implements RepositoryQuery {
    final DatastoreMappingContext datastoreMappingContext;
    final DatastoreQueryMethod queryMethod;
    final DatastoreTemplate datastoreTemplate;
    final Class<T> entityType;

    public AbstractDatastoreQuery(DatastoreQueryMethod queryMethod, DatastoreTemplate datastoreTemplate, DatastoreMappingContext datastoreMappingContext, Class<T> entityType) {
        this.queryMethod = queryMethod;
        this.datastoreTemplate = datastoreTemplate;
        this.datastoreMappingContext = datastoreMappingContext;
        this.entityType = entityType;
    }

    public QueryMethod getQueryMethod() {
        return this.queryMethod;
    }

    protected List applyProjection(List<T> rawResult) {
        if (rawResult == null) {
            return Collections.emptyList();
        }
        return rawResult.stream().map(this::processRawObjectForProjection).collect(Collectors.toList());
    }

    protected Object[] convertCollectionParamToCompatibleArray(List<?> param) {
        List<Object> converted;
        return converted.toArray((Object[])Array.newInstance((converted = param.stream().map(x -> this.datastoreTemplate.getDatastoreEntityConverter().getConversions().convertOnWriteSingle(x).get()).collect(Collectors.toList())).isEmpty() ? String.class : converted.get(0).getClass(), converted.size()));
    }

    @VisibleForTesting
    Object processRawObjectForProjection(T object) {
        return this.queryMethod.getResultProcessor().processResult(object);
    }

    public DatastoreTemplate getDatastoreTemplate() {
        return this.datastoreTemplate;
    }
}

