/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gcp.autoconfigure.core;

import com.google.api.gax.core.CredentialsProvider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.gcp.autoconfigure.core.GcpProperties;
import org.springframework.cloud.gcp.core.CredentialsSupplier;
import org.springframework.cloud.gcp.core.DefaultCredentialsProvider;
import org.springframework.cloud.gcp.core.DefaultGcpEnvironmentProvider;
import org.springframework.cloud.gcp.core.DefaultGcpProjectIdProvider;
import org.springframework.cloud.gcp.core.GcpEnvironmentProvider;
import org.springframework.cloud.gcp.core.GcpProjectIdProvider;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnProperty(name={"spring.cloud.gcp.core.enabled"}, havingValue="true", matchIfMissing=true)
@EnableConfigurationProperties(value={GcpProperties.class})
public class GcpContextAutoConfiguration {
    private static final Log LOGGER = LogFactory.getLog(GcpContextAutoConfiguration.class);
    private final GcpProperties gcpProperties;

    public GcpContextAutoConfiguration(GcpProperties gcpProperties) {
        this.gcpProperties = gcpProperties;
    }

    @Bean
    @ConditionalOnMissingBean
    public CredentialsProvider googleCredentials() throws Exception {
        return new DefaultCredentialsProvider((CredentialsSupplier)this.gcpProperties);
    }

    @Bean
    @ConditionalOnMissingBean
    public GcpProjectIdProvider gcpProjectIdProvider() {
        GcpProjectIdProvider projectIdProvider;
        Object object = projectIdProvider = this.gcpProperties.getProjectId() != null ? () -> this.gcpProperties.getProjectId() : new DefaultGcpProjectIdProvider();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)("The default project ID is " + projectIdProvider.getProjectId()));
        }
        return projectIdProvider;
    }

    @Bean
    @ConditionalOnMissingBean
    public static GcpEnvironmentProvider gcpEnvironmentProvider() {
        return new DefaultGcpEnvironmentProvider();
    }
}

