/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gcp.autoconfigure.config;

import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class GoogleConfigEnvironment {
    private List<Variable> variables;

    GoogleConfigEnvironment() {
    }

    List<Variable> getVariables() {
        if (this.variables == null) {
            return Collections.emptyList();
        }
        return this.variables;
    }

    void setVariables(List<Variable> variables) {
        this.variables = variables;
    }

    Map<String, Object> getConfig() {
        HashMap<String, Object> config = new HashMap<String, Object>();
        for (Variable variable : this.getVariables()) {
            String value = variable.getText() != null ? variable.getText() : variable.getValue();
            config.put(variable.getName(), value);
        }
        return config;
    }

    static class Variable {
        private String name;
        private String text;
        private String value;
        private String updateTime;

        Variable() {
        }

        String getName() {
            return this.name;
        }

        public void setName(String name) {
            String[] variableNameSplit;
            if (name != null && (variableNameSplit = name.split("/")).length > 0) {
                this.name = variableNameSplit[variableNameSplit.length - 1];
            }
        }

        String getText() {
            return this.text;
        }

        void setText(String text) {
            this.text = text;
        }

        String getValue() {
            return this.value;
        }

        void setValue(String value) {
            if (value != null) {
                this.value = this.decode(value);
            }
        }

        String getUpdateTime() {
            return this.updateTime;
        }

        void setUpdateTime(String updateTime) {
            this.updateTime = updateTime;
        }

        private String decode(String value) {
            byte[] decodedValue = Base64.getDecoder().decode(value);
            return new String(decodedValue, StandardCharsets.UTF_8);
        }
    }
}

